/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.visualizers.scatterplot.outlier;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreListener;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.math.linearalgebra.VMath;
import de.lmu.ifi.dbs.elki.math.linearalgebra.Vector;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierResult;
import de.lmu.ifi.dbs.elki.utilities.datastructures.hierarchy.Hierarchy;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTask;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTree;
import de.lmu.ifi.dbs.elki.visualization.VisualizerContext;
import de.lmu.ifi.dbs.elki.visualization.css.CSSClass;
import de.lmu.ifi.dbs.elki.visualization.gui.VisualizationPlot;
import de.lmu.ifi.dbs.elki.visualization.projections.Projection;
import de.lmu.ifi.dbs.elki.visualization.projector.ScatterPlotProjector;
import de.lmu.ifi.dbs.elki.visualization.style.StyleLibrary;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGPlot;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGUtil;
import de.lmu.ifi.dbs.elki.visualization.visualizers.AbstractVisFactory;
import de.lmu.ifi.dbs.elki.visualization.visualizers.Visualization;
import de.lmu.ifi.dbs.elki.visualization.visualizers.scatterplot.AbstractScatterplotVisualization;
import org.w3c.dom.Element;

@Title(value="COP: Correlation Outlier Probability")
@Reference(authors="Hans-Peter Kriegel, Peer Kr\u00f6ger, Erich Schubert, Arthur Zimek", title="Outlier Detection in Arbitrarily Oriented Subspaces", booktitle="Proc. IEEE International Conference on Data Mining (ICDM 2012)", url="http://dx.doi.org/10.1109/ICDM.2012.21")
public class COPVectorVisualization
extends AbstractVisFactory {
    public static final String NAME = "Error Vectors";

    @Override
    public Visualization makeVisualization(VisualizationTask visualizationTask, VisualizationPlot visualizationPlot, double d, double d2, Projection projection) {
        return new Instance(visualizationTask, visualizationPlot, d, d2, projection);
    }

    @Override
    public void processNewResult(VisualizerContext visualizerContext, Object object) {
        VisualizationTree.findNewSiblings(visualizerContext, object, OutlierResult.class, ScatterPlotProjector.class, new VisualizationTree.Handler2<OutlierResult, ScatterPlotProjector<?>>(){

            @Override
            public void process(VisualizerContext visualizerContext, OutlierResult outlierResult, ScatterPlotProjector<?> scatterPlotProjector) {
                Relation<?> relation = scatterPlotProjector.getRelation();
                if (!TypeUtil.NUMBER_VECTOR_FIELD.isAssignableFromType(relation.getDataTypeInformation())) {
                    return;
                }
                Hierarchy.Iter<Relation> iter = VisualizationTree.filterResults(visualizerContext, outlierResult, Relation.class);
                while (iter.valid()) {
                    Relation relation2 = iter.get();
                    if (relation2.getShortName().equals("cop-errorvec")) {
                        VisualizationTask visualizationTask = new VisualizationTask(COPVectorVisualization.NAME, visualizerContext, relation2, relation, COPVectorVisualization.this);
                        visualizationTask.level = 100;
                        visualizationTask.addUpdateFlags(9);
                        visualizerContext.addVis(outlierResult, visualizationTask);
                        visualizerContext.addVis(scatterPlotProjector, visualizationTask);
                    }
                    iter.advance();
                }
            }
        });
    }

    public class Instance
    extends AbstractScatterplotVisualization
    implements DataStoreListener {
        public static final String VEC = "copvec";
        protected Relation<Vector> result;

        public Instance(VisualizationTask visualizationTask, VisualizationPlot visualizationPlot, double d, double d2, Projection projection) {
            super(visualizationTask, visualizationPlot, d, d2, projection);
            this.result = (Relation)visualizationTask.getResult();
            this.addListeners();
        }

        @Override
        public void fullRedraw() {
            this.setupCanvas();
            this.setupCSS(this.svgp);
            DBIDIter dBIDIter = this.sample.getSample().iter();
            while (dBIDIter.valid()) {
                double[] dArray;
                NumberVector numberVector;
                double[] dArray2;
                Vector vector = this.result.get(dBIDIter);
                if (vector != null && !(VMath.euclideanLength(dArray2 = this.proj.fastProjectRelativeDataToRenderSpace(vector)) < 0.01) && (numberVector = (NumberVector)this.rel.get(dBIDIter)) != null && (dArray = this.proj.fastProjectDataToRenderSpace(numberVector))[0] == dArray[0] && dArray[1] == dArray[1]) {
                    Element element = this.svgp.svgLine(dArray[0], dArray[1], dArray[0] + dArray2[0], dArray[1] + dArray2[1]);
                    SVGUtil.addCSSClass(element, VEC);
                    this.layer.appendChild(element);
                }
                dBIDIter.advance();
            }
        }

        private void setupCSS(SVGPlot sVGPlot) {
            StyleLibrary styleLibrary = this.context.getStyleLibrary();
            CSSClass cSSClass = new CSSClass(sVGPlot, VEC);
            cSSClass.setStatement("stroke-width", styleLibrary.getLineWidth("plot") / 2.0);
            String string = "red";
            cSSClass.setStatement("stroke", string);
            cSSClass.setStatement("fill", "none");
            sVGPlot.addCSSClassOrLogError(cSSClass);
        }
    }
}

