/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.visualizers.scatterplot.selection;

import de.lmu.ifi.dbs.elki.data.ModifiableHyperBoundingBox;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.HashSetModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.database.relation.RelationUtil;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.result.DBIDSelection;
import de.lmu.ifi.dbs.elki.result.RangeSelection;
import de.lmu.ifi.dbs.elki.utilities.BitsUtil;
import de.lmu.ifi.dbs.elki.utilities.datastructures.hierarchy.Hierarchy;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTask;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTree;
import de.lmu.ifi.dbs.elki.visualization.VisualizerContext;
import de.lmu.ifi.dbs.elki.visualization.batikutil.DragableArea;
import de.lmu.ifi.dbs.elki.visualization.css.CSSClass;
import de.lmu.ifi.dbs.elki.visualization.gui.VisualizationPlot;
import de.lmu.ifi.dbs.elki.visualization.projections.Projection;
import de.lmu.ifi.dbs.elki.visualization.projector.ScatterPlotProjector;
import de.lmu.ifi.dbs.elki.visualization.style.StyleLibrary;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGPlot;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGUtil;
import de.lmu.ifi.dbs.elki.visualization.visualizers.AbstractVisFactory;
import de.lmu.ifi.dbs.elki.visualization.visualizers.Visualization;
import de.lmu.ifi.dbs.elki.visualization.visualizers.scatterplot.AbstractScatterplotVisualization;
import org.w3c.dom.Element;
import org.w3c.dom.events.Event;
import org.w3c.dom.svg.SVGPoint;

public class SelectionToolCubeVisualization
extends AbstractVisFactory {
    private static final Logging LOG = Logging.getLogger(SelectionToolCubeVisualization.class);
    private static final String NAME = "Range Selection";

    @Override
    public Visualization makeVisualization(VisualizationTask visualizationTask, VisualizationPlot visualizationPlot, double d, double d2, Projection projection) {
        return new Instance(visualizationTask, visualizationPlot, d, d2, projection);
    }

    @Override
    public void processNewResult(VisualizerContext visualizerContext, Object object) {
        Hierarchy.Iter<ScatterPlotProjector> iter = VisualizationTree.filter(visualizerContext, object, ScatterPlotProjector.class);
        while (iter.valid()) {
            ScatterPlotProjector scatterPlotProjector = iter.get();
            Relation relation = scatterPlotProjector.getRelation();
            if (TypeUtil.NUMBER_VECTOR_FIELD.isAssignableFromType(relation.getDataTypeInformation())) {
                VisualizationTask visualizationTask = new VisualizationTask(NAME, visualizerContext, visualizerContext.getSelectionResult(), relation, this);
                visualizationTask.level = 1000;
                visualizationTask.tool = true;
                visualizationTask.addFlags(5);
                visualizationTask.addUpdateFlags(2);
                visualizationTask.initDefaultVisibility(false);
                visualizerContext.addVis(visualizerContext.getSelectionResult(), visualizationTask);
                visualizerContext.addVis(scatterPlotProjector, visualizationTask);
            }
            iter.advance();
        }
    }

    public class Instance
    extends AbstractScatterplotVisualization
    implements DragableArea.DragListener {
        private static final String CSS_RANGEMARKER = "selectionRangeMarker";
        private int dim;
        private Element rtag;
        private Element etag;

        public Instance(VisualizationTask visualizationTask, VisualizationPlot visualizationPlot, double d, double d2, Projection projection) {
            super(visualizationTask, visualizationPlot, d, d2, projection);
            this.dim = RelationUtil.dimensionality(this.rel);
            this.addListeners();
        }

        @Override
        public void fullRedraw() {
            this.setupCanvas();
            this.addCSSClasses(this.svgp);
            this.rtag = this.svgp.svgElement("g");
            SVGUtil.addCSSClass(this.rtag, CSS_RANGEMARKER);
            this.layer.appendChild(this.rtag);
            DragableArea dragableArea = new DragableArea((SVGPlot)this.svgp, -60.0, -70.0, 130.0, 140.0, this);
            this.etag = dragableArea.getElement();
            this.layer.appendChild(this.etag);
        }

        private void deleteChildren(Element element) {
            while (element.hasChildNodes()) {
                element.removeChild(element.getLastChild());
            }
        }

        private void updateSelectionRectKoordinates(double d, double d2, double d3, double d4, ModifiableHyperBoundingBox modifiableHyperBoundingBox) {
            double[] dArray = this.proj.fastProjectRenderToDataSpace(d, d3);
            double[] dArray2 = this.proj.fastProjectRenderToDataSpace(d2, d4);
            long[] lArray = this.proj.getVisibleDimensions2D();
            int n = BitsUtil.nextSetBit(lArray, 0);
            while (n >= 0) {
                modifiableHyperBoundingBox.setMin(n, Math.min(dArray[n], dArray2[n]));
                modifiableHyperBoundingBox.setMax(n, Math.max(dArray[n], dArray2[n]));
                n = BitsUtil.nextSetBit(lArray, n + 1);
            }
        }

        @Override
        public boolean startDrag(SVGPoint sVGPoint, Event event) {
            return true;
        }

        @Override
        public boolean duringDrag(SVGPoint sVGPoint, SVGPoint sVGPoint2, Event event, boolean bl) {
            this.deleteChildren(this.rtag);
            double d = Math.min(sVGPoint.getX(), sVGPoint2.getX());
            double d2 = Math.min(sVGPoint.getY(), sVGPoint2.getY());
            double d3 = Math.abs(sVGPoint.getX() - sVGPoint2.getX());
            double d4 = Math.abs(sVGPoint.getY() - sVGPoint2.getY());
            this.rtag.appendChild(this.svgp.svgRect(d, d2, d3, d4));
            return true;
        }

        @Override
        public boolean endDrag(SVGPoint sVGPoint, SVGPoint sVGPoint2, Event event, boolean bl) {
            this.deleteChildren(this.rtag);
            if (sVGPoint.getX() != sVGPoint2.getX() || sVGPoint.getY() != sVGPoint2.getY()) {
                this.updateSelection(this.proj, sVGPoint, sVGPoint2);
            }
            return true;
        }

        private void updateSelection(Projection projection, SVGPoint sVGPoint, SVGPoint sVGPoint2) {
            if (sVGPoint == null || sVGPoint2 == null) {
                LOG.warning("no rect selected: p1: " + sVGPoint + " p2: " + sVGPoint2);
                return;
            }
            DBIDSelection dBIDSelection = this.context.getSelection();
            HashSetModifiableDBIDs hashSetModifiableDBIDs = dBIDSelection != null ? DBIDUtil.newHashSet(dBIDSelection.getSelectedIds()) : DBIDUtil.newHashSet();
            double d = Math.min(sVGPoint.getX(), sVGPoint2.getX());
            double d2 = Math.max(sVGPoint.getX(), sVGPoint2.getX());
            double d3 = Math.max(sVGPoint.getY(), sVGPoint2.getY());
            double d4 = Math.min(sVGPoint.getY(), sVGPoint2.getY());
            ModifiableHyperBoundingBox modifiableHyperBoundingBox = dBIDSelection instanceof RangeSelection ? ((RangeSelection)dBIDSelection).getRanges() : new ModifiableHyperBoundingBox(this.dim, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
            this.updateSelectionRectKoordinates(d, d2, d3, d4, modifiableHyperBoundingBox);
            hashSetModifiableDBIDs.clear();
            DBIDIter dBIDIter = this.rel.iterDBIDs();
            while (dBIDIter.valid()) {
                block4: {
                    NumberVector numberVector = (NumberVector)this.rel.get(dBIDIter);
                    for (int i = 0; i < this.dim; ++i) {
                        double d5;
                        double d6 = modifiableHyperBoundingBox.getMin(i);
                        double d7 = modifiableHyperBoundingBox.getMax(i);
                        if (!(d7 < Double.POSITIVE_INFINITY) && !(d6 > Double.NEGATIVE_INFINITY) || !((d5 = numberVector.doubleValue(i)) < d6) && !(d5 > d7)) {
                            continue;
                        }
                        break block4;
                    }
                    hashSetModifiableDBIDs.add(dBIDIter);
                }
                dBIDIter.advance();
            }
            this.context.setSelection(new RangeSelection(hashSetModifiableDBIDs, modifiableHyperBoundingBox));
        }

        protected void addCSSClasses(SVGPlot sVGPlot) {
            if (!sVGPlot.getCSSClassManager().contains(CSS_RANGEMARKER)) {
                CSSClass cSSClass = new CSSClass(this, CSS_RANGEMARKER);
                StyleLibrary styleLibrary = this.context.getStyleLibrary();
                cSSClass.setStatement("fill", styleLibrary.getColor("plot.selection.active"));
                cSSClass.setStatement("opacity", styleLibrary.getOpacity("plot.selection.active"));
                sVGPlot.addCSSClassOrLogError(cSSClass);
            }
        }
    }
}

