/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.algorithm.multiobjective.spea2;

import java.util.ArrayList;
import java.util.List;
import org.uma.jmetal.algorithm.impl.AbstractGeneticAlgorithm;
import org.uma.jmetal.algorithm.multiobjective.spea2.util.EnvironmentalSelection;
import org.uma.jmetal.operator.CrossoverOperator;
import org.uma.jmetal.operator.MutationOperator;
import org.uma.jmetal.operator.SelectionOperator;
import org.uma.jmetal.problem.Problem;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.evaluator.SolutionListEvaluator;
import org.uma.jmetal.util.solutionattribute.impl.StrengthRawFitness;

public class SPEA2<S extends Solution<?>>
extends AbstractGeneticAlgorithm<S, List<S>> {
    protected final int maxIterations;
    protected final int populationSize;
    protected final Problem<S> problem;
    protected final SolutionListEvaluator<S> evaluator;
    protected int iterations;
    protected List<S> archive;
    private final StrengthRawFitness<S> strenghtRawFitness = new StrengthRawFitness();
    private final EnvironmentalSelection<S> environmentalSelection;

    public SPEA2(Problem<S> problem, int maxIterations, int populationSize, CrossoverOperator<S> crossoverOperator, MutationOperator<S> mutationOperator, SelectionOperator<List<S>, S> selectionOperator, SolutionListEvaluator<S> evaluator) {
        this.problem = problem;
        this.maxIterations = maxIterations;
        this.populationSize = populationSize;
        this.crossoverOperator = crossoverOperator;
        this.mutationOperator = mutationOperator;
        this.selectionOperator = selectionOperator;
        this.environmentalSelection = new EnvironmentalSelection(populationSize);
        this.archive = new ArrayList<S>(populationSize);
        this.evaluator = evaluator;
    }

    @Override
    protected void initProgress() {
        this.iterations = 1;
    }

    @Override
    protected void updateProgress() {
        ++this.iterations;
    }

    @Override
    protected boolean isStoppingConditionReached() {
        return this.iterations >= this.maxIterations;
    }

    @Override
    protected List<S> createInitialPopulation() {
        ArrayList<S> population = new ArrayList<S>(this.populationSize);
        for (int i = 0; i < this.populationSize; ++i) {
            S newIndividual = this.problem.createSolution();
            population.add(newIndividual);
        }
        return population;
    }

    @Override
    protected List<S> evaluatePopulation(List<S> population) {
        population = this.evaluator.evaluate(population, this.problem);
        return population;
    }

    @Override
    protected List<S> selection(List<S> population) {
        ArrayList<S> union = new ArrayList<S>(2 * this.populationSize);
        union.addAll(this.archive);
        union.addAll(population);
        this.strenghtRawFitness.computeDensityEstimator(union);
        this.archive = this.environmentalSelection.execute(union);
        return this.archive;
    }

    @Override
    protected List<S> reproduction(List<S> population) {
        ArrayList offSpringPopulation = new ArrayList(this.populationSize);
        while (offSpringPopulation.size() < this.populationSize) {
            ArrayList<Solution> parents = new ArrayList<Solution>(2);
            Solution candidateFirstParent = (Solution)this.selectionOperator.execute(population);
            parents.add(candidateFirstParent);
            Solution candidateSecondParent = (Solution)this.selectionOperator.execute(population);
            parents.add(candidateSecondParent);
            List offspring = (List)this.crossoverOperator.execute(parents);
            this.mutationOperator.execute(offspring.get(0));
            offSpringPopulation.add(offspring.get(0));
        }
        return offSpringPopulation;
    }

    @Override
    protected List<S> replacement(List<S> population, List<S> offspringPopulation) {
        return offspringPopulation;
    }

    @Override
    public List<S> getResult() {
        return this.archive;
    }
}

