/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.problem.multiobjective.zdt;

import java.util.ArrayList;
import org.uma.jmetal.problem.impl.AbstractDoubleProblem;
import org.uma.jmetal.solution.DoubleSolution;

public class ZDT4
extends AbstractDoubleProblem {
    public ZDT4() {
        this(10);
    }

    public ZDT4(Integer numberOfVariables) {
        this.setNumberOfVariables(numberOfVariables);
        this.setNumberOfObjectives(2);
        this.setName("ZDT4");
        ArrayList<Double> lowerLimit = new ArrayList<Double>(this.getNumberOfVariables());
        ArrayList<Double> upperLimit = new ArrayList<Double>(this.getNumberOfVariables());
        lowerLimit.add(0.0);
        upperLimit.add(1.0);
        for (int i = 0; i < this.getNumberOfVariables(); ++i) {
            lowerLimit.add(-5.0);
            upperLimit.add(5.0);
        }
        this.setLowerLimit(lowerLimit);
        this.setUpperLimit(upperLimit);
    }

    @Override
    public void evaluate(DoubleSolution solution) {
        int numberOfVariables = this.getNumberOfVariables();
        double[] f = new double[this.getNumberOfObjectives()];
        double[] x = new double[numberOfVariables];
        f[0] = (Double)solution.getVariableValue(0);
        double g = this.evalG(solution);
        double h = this.evalH(f[0], g);
        f[1] = h * g;
        solution.setObjective(0, f[0]);
        solution.setObjective(1, f[1]);
    }

    public double evalG(DoubleSolution solution) {
        double g = 0.0;
        for (int var = 1; var < solution.getNumberOfVariables(); ++var) {
            g += Math.pow((Double)solution.getVariableValue(var), 2.0) + -10.0 * Math.cos(Math.PI * 4 * (Double)solution.getVariableValue(var));
        }
        double constant = 1.0 + 10.0 * (double)(solution.getNumberOfVariables() - 1);
        return g + constant;
    }

    public double evalH(double f, double g) {
        return 1.0 - Math.sqrt(f / g);
    }
}

