/*
 * Decompiled with CFR 0.152.
 */
package org.jgap.impl;

import java.util.Collections;
import java.util.Iterator;
import org.jgap.Configuration;
import org.jgap.Genotype;
import org.jgap.IChromosome;
import org.jgap.InvalidConfigurationException;
import org.jgap.NaturalSelector;
import org.jgap.Population;
import org.jgap.util.CloneException;
import org.jgap.util.ICloneable;

public class StandardPostSelector
extends NaturalSelector
implements ICloneable {
    private static final String CVS_REVISION = "$Revision: 1.4 $";
    private Population m_chromosomes;
    private boolean m_needsSorting;
    private NaturalSelector.FitnessValueComparator m_fitnessValueComparator;

    public StandardPostSelector() throws InvalidConfigurationException {
        this(Genotype.getStaticConfiguration());
    }

    public StandardPostSelector(Configuration a_config) throws InvalidConfigurationException {
        super(a_config);
        this.m_chromosomes = new Population(a_config);
        this.m_needsSorting = false;
        this.m_fitnessValueComparator = new NaturalSelector.FitnessValueComparator();
    }

    protected void add(IChromosome a_chromosomeToAdd) {
        a_chromosomeToAdd.setIsSelectedForNextGeneration(false);
        this.m_chromosomes.addChromosome(a_chromosomeToAdd);
        this.m_needsSorting = true;
    }

    public void select(int a_howManyToSelect, Population a_from_pop, Population a_to_pop) {
        IChromosome selectedChromosome;
        int chromsSize;
        if (a_from_pop != null) {
            int popSize = a_from_pop.size();
            if (popSize < 1) {
                throw new IllegalStateException("Population size must be greater 0");
            }
            for (int i = 0; i < popSize; ++i) {
                this.add(a_from_pop.getChromosome(i));
            }
        }
        if ((chromsSize = this.m_chromosomes.size()) < 1) {
            throw new IllegalStateException("Number of chromosomes must be greater 0");
        }
        int canBeSelected = a_howManyToSelect > chromsSize ? chromsSize : a_howManyToSelect;
        int neededSize = a_howManyToSelect;
        Iterator it = this.m_chromosomes.iterator();
        while (it.hasNext()) {
            IChromosome c = (IChromosome)it.next();
            if (!(Math.abs(c.getFitnessValueDirectly() - -1.0) < 1.0E-7)) continue;
            a_to_pop.addChromosome(c);
            it.remove();
            if (--canBeSelected >= 1) continue;
            break;
        }
        if (this.m_needsSorting && canBeSelected > 0) {
            Collections.sort(this.m_chromosomes.getChromosomes(), this.m_fitnessValueComparator);
            this.m_needsSorting = false;
        }
        for (int i = 0; i < canBeSelected; ++i) {
            selectedChromosome = this.m_chromosomes.getChromosome(i);
            selectedChromosome.setIsSelectedForNextGeneration(true);
            a_to_pop.addChromosome(selectedChromosome);
        }
        int toAdd = neededSize - a_to_pop.size();
        for (int i = 0; i < toAdd; ++i) {
            selectedChromosome = this.m_chromosomes.getChromosome(i % chromsSize);
            selectedChromosome.setIsSelectedForNextGeneration(true);
            a_to_pop.addChromosome(selectedChromosome);
        }
    }

    public void empty() {
        this.m_chromosomes.getChromosomes().clear();
        this.m_needsSorting = false;
    }

    public boolean returnsUniqueChromosomes() {
        return true;
    }

    public boolean equals(Object a_o) {
        if (a_o == null) {
            return false;
        }
        StandardPostSelector other = (StandardPostSelector)a_o;
        if (!this.m_fitnessValueComparator.getClass().getName().equals(other.m_fitnessValueComparator.getClass().getName())) {
            return false;
        }
        return this.m_chromosomes.equals(other.m_chromosomes);
    }

    public Object clone() {
        try {
            StandardPostSelector sel = new StandardPostSelector(this.getConfiguration());
            sel.m_needsSorting = this.m_needsSorting;
            return sel;
        }
        catch (Throwable t) {
            throw new CloneException(t);
        }
    }
}

