/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.correlation.cash;

import de.lmu.ifi.dbs.elki.algorithm.clustering.correlation.cash.ParameterizationFunction;
import de.lmu.ifi.dbs.elki.data.HyperBoundingBox;
import de.lmu.ifi.dbs.elki.data.spatial.SpatialUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBID;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.HashSetModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.ModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.utilities.FormatUtil;
import java.util.HashMap;
import java.util.Map;

public class CASHIntervalSplit {
    private Relation<ParameterizationFunction> database;
    private Map<HyperBoundingBox, Map<DBID, Double>> f_minima;
    private Map<HyperBoundingBox, Map<DBID, Double>> f_maxima;
    private int minPts;
    private static final Logging LOG = Logging.getLogger(CASHIntervalSplit.class);

    public CASHIntervalSplit(Relation<ParameterizationFunction> relation, int n) {
        this.database = relation;
        this.minPts = n;
        this.f_minima = new HashMap<HyperBoundingBox, Map<DBID, Double>>();
        this.f_maxima = new HashMap<HyperBoundingBox, Map<DBID, Double>>();
    }

    public ModifiableDBIDs determineIDs(DBIDs dBIDs, HyperBoundingBox hyperBoundingBox, double d, double d2) {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = stringBuilder = LOG.isDebugging() ? new StringBuilder() : null;
        if (stringBuilder != null) {
            stringBuilder.append("interval ").append(hyperBoundingBox);
        }
        HashSetModifiableDBIDs hashSetModifiableDBIDs = DBIDUtil.newHashSet(dBIDs.size());
        Map<DBID, Double> map = this.f_minima.get(hyperBoundingBox);
        Map<DBID, Double> map2 = this.f_maxima.get(hyperBoundingBox);
        if (map == null || map2 == null) {
            map = new HashMap<DBID, Double>();
            this.f_minima.put(hyperBoundingBox, map);
            map2 = new HashMap<DBID, Double>();
            this.f_maxima.put(hyperBoundingBox, map2);
        }
        DBIDIter dBIDIter = dBIDs.iter();
        while (dBIDIter.valid()) {
            DBID dBID = DBIDUtil.deref(dBIDIter);
            Double d3 = map.get(dBID);
            Double d4 = map2.get(dBID);
            if (d3 == null) {
                ParameterizationFunction parameterizationFunction = this.database.get(dBID);
                HyperBoundingBox hyperBoundingBox2 = parameterizationFunction.determineAlphaMinMax(hyperBoundingBox);
                d3 = parameterizationFunction.function(SpatialUtil.getMin(hyperBoundingBox2));
                d4 = parameterizationFunction.function(SpatialUtil.getMax(hyperBoundingBox2));
                map.put(dBID, d3);
                map2.put(dBID, d4);
            }
            if (stringBuilder != null) {
                stringBuilder.append("\n\nf_min ").append(d3);
                stringBuilder.append("\nf_max ").append(d4);
                stringBuilder.append("\nd_min ").append(d);
                stringBuilder.append("\nd_max ").append(d2);
            }
            if (d3 - d4 > 1.0E-10) {
                throw new IllegalArgumentException("Houston, we have a problem: f_min > f_max! \nf_min[" + FormatUtil.format(SpatialUtil.centroid(hyperBoundingBox)) + "] = " + d3 + "\nf_max[" + FormatUtil.format(SpatialUtil.centroid(hyperBoundingBox)) + "] = " + d4 + "\nf " + this.database.get(dBID));
            }
            if (d3 <= d2 && d4 >= d) {
                hashSetModifiableDBIDs.add(dBID);
                if (stringBuilder != null) {
                    stringBuilder.append("\nid ").append(dBID).append(" appended");
                }
            } else if (stringBuilder != null) {
                stringBuilder.append("\nid ").append(dBID).append(" NOT appended");
            }
            dBIDIter.advance();
        }
        if (stringBuilder != null) {
            stringBuilder.append("\nchildIds ").append(hashSetModifiableDBIDs.size());
            LOG.debugFine(stringBuilder.toString());
        }
        if (hashSetModifiableDBIDs.size() < this.minPts) {
            return null;
        }
        return hashSetModifiableDBIDs;
    }
}

