/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.data.type;

import de.lmu.ifi.dbs.elki.data.FeatureVector;
import de.lmu.ifi.dbs.elki.data.type.SimpleTypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.utilities.io.ByteBufferSerializer;

public class VectorTypeInformation<V extends FeatureVector<?>>
extends SimpleTypeInformation<V> {
    private final FeatureVector.Factory<V, ?> factory;
    protected final int mindim;
    protected final int maxdim;

    public static <V extends FeatureVector<?>> VectorTypeInformation<V> typeRequest(Class<? super V> clazz) {
        return new VectorTypeInformation<V>(clazz, -1, Integer.MAX_VALUE);
    }

    public static <V extends FeatureVector<?>> VectorTypeInformation<V> typeRequest(Class<? super V> clazz, int n, int n2) {
        return new VectorTypeInformation<V>(clazz, n, n2);
    }

    public VectorTypeInformation(Class<? super V> clazz, int n, int n2) {
        super(clazz);
        this.factory = null;
        assert (n <= n2);
        this.mindim = n;
        this.maxdim = n2;
    }

    public VectorTypeInformation(FeatureVector.Factory<V, ?> factory, ByteBufferSerializer<? super V> byteBufferSerializer, int n, int n2) {
        super(factory.getRestrictionClass(), byteBufferSerializer);
        this.factory = factory;
        assert (n <= n2);
        this.mindim = n;
        this.maxdim = n2;
    }

    @Override
    public boolean isAssignableFromType(TypeInformation typeInformation) {
        if (!super.isAssignableFromType(typeInformation)) {
            return false;
        }
        if (!(typeInformation instanceof VectorTypeInformation)) {
            return false;
        }
        VectorTypeInformation vectorTypeInformation = (VectorTypeInformation)typeInformation;
        assert (vectorTypeInformation.mindim <= vectorTypeInformation.maxdim);
        if (this.mindim > vectorTypeInformation.mindim) {
            return false;
        }
        return vectorTypeInformation.maxdim <= this.maxdim;
    }

    @Override
    public boolean isAssignableFrom(Object object) {
        if (!super.isAssignableFrom(object)) {
            return false;
        }
        int n = ((FeatureVector)this.cast(object)).getDimensionality();
        if (n < this.mindim) {
            return false;
        }
        return n <= this.maxdim;
    }

    public FeatureVector.Factory<V, ?> getFactory() {
        if (this.factory == null) {
            throw new UnsupportedOperationException("Requesting factory for a type request!");
        }
        return this.factory;
    }

    public int mindim() {
        if (this.mindim < 0) {
            throw new UnsupportedOperationException("Requesting dimensionality for a request without defined dimensionality!");
        }
        return this.mindim;
    }

    public int maxdim() {
        if (this.maxdim == Integer.MAX_VALUE) {
            throw new UnsupportedOperationException("Requesting dimensionality for a request without defined dimensionality!");
        }
        return this.maxdim;
    }

    public int getMultiplicity() {
        return 1;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(super.toString());
        stringBuilder.append(",variable");
        if (this.mindim >= 0) {
            stringBuilder.append(",mindim=").append(this.mindim);
        }
        if (this.maxdim < Integer.MAX_VALUE) {
            stringBuilder.append(",maxdim=").append(this.maxdim);
        }
        return stringBuilder.toString();
    }
}

