/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.datasource.filter.transform;

import de.lmu.ifi.dbs.elki.data.DoubleVector;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.VectorUtil;
import de.lmu.ifi.dbs.elki.data.type.SimpleTypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.data.type.VectorFieldTypeInformation;
import de.lmu.ifi.dbs.elki.datasource.filter.AbstractVectorStreamConversionFilter;
import de.lmu.ifi.dbs.elki.utilities.BitsUtil;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntListParameter;

public class NumberVectorFeatureSelectionFilter<V extends NumberVector>
extends AbstractVectorStreamConversionFilter<V, V> {
    private long[] selectedAttributes;

    public NumberVectorFeatureSelectionFilter(long[] lArray) {
        this.selectedAttributes = lArray;
    }

    @Override
    protected V filterSingleObject(V v) {
        return VectorUtil.project(v, this.getSelectedAttributes(), this.factory);
    }

    @Override
    protected SimpleTypeInformation<? super V> getInputTypeRestriction() {
        return TypeUtil.NUMBER_VECTOR_FIELD;
    }

    @Override
    protected SimpleTypeInformation<? super V> convertedType(SimpleTypeInformation<V> simpleTypeInformation) {
        this.initializeOutputType(simpleTypeInformation);
        return new VectorFieldTypeInformation(this.factory, this.getDimensionality());
    }

    public void setSelectedAttributes(long[] lArray) {
        this.selectedAttributes = lArray;
    }

    public long[] getSelectedAttributes() {
        return this.selectedAttributes;
    }

    public int getDimensionality() {
        return BitsUtil.cardinality(this.selectedAttributes);
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID SELECTED_ATTRIBUTES_ID = new OptionID("projectionfilter.selectedattributes", "a comma separated array of integer values d_i, where 0 <= d_i < the dimensionality of the feature space specifying the dimensions to be considered for projection. If this parameter is not set, no dimensions will be considered, i.e. the projection is a zero-dimensional feature space");
        protected long[] selectedAttributes;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            super.makeOptions(parameterization);
            IntListParameter intListParameter = (IntListParameter)new IntListParameter(SELECTED_ATTRIBUTES_ID).addConstraint(CommonConstraints.GREATER_EQUAL_ZERO_INT_LIST);
            if (parameterization.grab(intListParameter)) {
                this.selectedAttributes = intListParameter.getValueAsBitSet();
            }
        }

        @Override
        protected NumberVectorFeatureSelectionFilter<DoubleVector> makeInstance() {
            return new NumberVectorFeatureSelectionFilter<DoubleVector>(this.selectedAttributes);
        }
    }
}

