/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.distribution;

import de.lmu.ifi.dbs.elki.math.random.RandomFactory;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.AbstractDistribution;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.BetaDistribution;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.GammaDistribution;
import de.lmu.ifi.dbs.elki.utilities.exceptions.NotImplementedException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import java.util.Random;

public class StudentsTDistribution
extends AbstractDistribution {
    private final int v;

    public StudentsTDistribution(int n) {
        this(n, (Random)null);
    }

    public StudentsTDistribution(int n, Random random) {
        super(random);
        this.v = n;
    }

    public StudentsTDistribution(int n, RandomFactory randomFactory) {
        super(randomFactory);
        this.v = n;
    }

    @Override
    public double pdf(double d) {
        return StudentsTDistribution.pdf(d, this.v);
    }

    @Override
    public double cdf(double d) {
        return StudentsTDistribution.cdf(d, this.v);
    }

    @Override
    public double quantile(double d) {
        throw new NotImplementedException("Not yet supported.");
    }

    @Override
    public double nextRandom() {
        throw new NotImplementedException("Not yet supported.");
    }

    public static double pdf(double d, int n) {
        return Math.exp(GammaDistribution.logGamma((double)(n + 1) * 0.5) - GammaDistribution.logGamma((double)n * 0.5)) * (1.0 / Math.sqrt((double)n * Math.PI)) * Math.pow(1.0 + d * d / (double)n, -((double)(n + 1) * 0.5));
    }

    public static double cdf(double d, int n) {
        double d2 = (double)n / (d * d + (double)n);
        return 1.0 - 0.5 * BetaDistribution.regularizedIncBeta(d2, (double)n * 0.5, 0.5);
    }

    @Override
    public String toString() {
        return "StudentsTDistribution(v=" + this.v + ")";
    }

    public static class Parameterizer
    extends AbstractDistribution.Parameterizer {
        public static final OptionID NU_ID = new OptionID("distribution.studentst.nu", "Degrees of freedom.");
        int nu;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            super.makeOptions(parameterization);
            IntParameter intParameter = new IntParameter(NU_ID);
            if (parameterization.grab(intParameter)) {
                this.nu = intParameter.intValue();
            }
        }

        @Override
        protected StudentsTDistribution makeInstance() {
            return new StudentsTDistribution(this.nu, this.rnd);
        }
    }
}

