/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.svg;

import de.lmu.ifi.dbs.elki.math.geometry.SweepHullDelaunay2D;
import de.lmu.ifi.dbs.elki.math.linearalgebra.VMath;
import de.lmu.ifi.dbs.elki.visualization.projections.CanvasSize;
import de.lmu.ifi.dbs.elki.visualization.projections.Projection2D;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGPath;
import java.util.List;

public class VoronoiDraw {
    public static SVGPath drawDelaunay(Projection2D projection2D, List<SweepHullDelaunay2D.Triangle> list, List<double[]> list2) {
        SVGPath sVGPath = new SVGPath();
        for (SweepHullDelaunay2D.Triangle triangle : list) {
            sVGPath.moveTo(projection2D.fastProjectDataToRenderSpace(list2.get(triangle.a)));
            sVGPath.drawTo(projection2D.fastProjectDataToRenderSpace(list2.get(triangle.b)));
            sVGPath.drawTo(projection2D.fastProjectDataToRenderSpace(list2.get(triangle.c)));
            sVGPath.close();
        }
        return sVGPath;
    }

    public static SVGPath drawVoronoi(Projection2D projection2D, List<SweepHullDelaunay2D.Triangle> list, List<double[]> list2) {
        SVGPath sVGPath = new SVGPath();
        CanvasSize canvasSize = projection2D.estimateViewport();
        for (int i = 0; i < list.size(); ++i) {
            double d;
            double[] dArray;
            Object object;
            SweepHullDelaunay2D.Triangle triangle = list.get(i);
            double[] dArray2 = projection2D.fastProjectDataToRenderSpace(triangle.m.getArrayRef());
            if (triangle.ab > i) {
                object = list.get(triangle.ab);
                sVGPath.moveTo(dArray2);
                sVGPath.drawTo(projection2D.fastProjectDataToRenderSpace(((SweepHullDelaunay2D.Triangle)object).m.getArrayRef()));
            } else if (triangle.ab < 0) {
                object = VMath.minus(list2.get(triangle.a), list2.get(triangle.b));
                VMath.rotate90Equals((double[])object);
                dArray = projection2D.fastProjectRelativeDataToRenderSpace((double[])object);
                d = canvasSize.continueToMargin(dArray2, dArray);
                if (d > 0.0) {
                    sVGPath.moveTo(dArray2);
                    sVGPath.relativeLineTo(d * dArray[0], d * dArray[1]);
                }
            }
            if (triangle.bc > i) {
                object = list.get(triangle.bc);
                sVGPath.moveTo(dArray2);
                sVGPath.drawTo(projection2D.fastProjectDataToRenderSpace(((SweepHullDelaunay2D.Triangle)object).m.getArrayRef()));
            } else if (triangle.bc < 0) {
                object = VMath.minus(list2.get(triangle.b), list2.get(triangle.c));
                VMath.rotate90Equals((double[])object);
                dArray = projection2D.fastProjectRelativeDataToRenderSpace((double[])object);
                d = canvasSize.continueToMargin(dArray2, dArray);
                if (d > 0.0) {
                    sVGPath.moveTo(dArray2);
                    sVGPath.relativeLineTo(d * dArray[0], d * dArray[1]);
                }
            }
            if (triangle.ca > i) {
                object = list.get(triangle.ca);
                sVGPath.moveTo(dArray2);
                sVGPath.drawTo(projection2D.fastProjectDataToRenderSpace(((SweepHullDelaunay2D.Triangle)object).m.getArrayRef()));
                continue;
            }
            if (triangle.ca >= 0) continue;
            object = VMath.minus(list2.get(triangle.c), list2.get(triangle.a));
            VMath.rotate90Equals((double[])object);
            dArray = projection2D.fastProjectRelativeDataToRenderSpace((double[])object);
            d = canvasSize.continueToMargin(dArray2, dArray);
            if (!(d > 0.0)) continue;
            sVGPath.moveTo(dArray2);
            sVGPath.relativeLineTo(d * dArray[0], d * dArray[1]);
        }
        return sVGPath;
    }

    public static SVGPath drawFakeVoronoi(Projection2D projection2D, List<double[]> list) {
        CanvasSize canvasSize = projection2D.estimateViewport();
        SVGPath sVGPath = new SVGPath();
        double[] dArray = VMath.minus(list.get(1), list.get(0));
        VMath.rotate90Equals(dArray);
        double[] dArray2 = projection2D.fastProjectRelativeDataToRenderSpace(dArray);
        double[] dArray3 = VMath.plus(list.get(0), list.get(1));
        VMath.timesEquals(dArray3, 0.5);
        double[] dArray4 = projection2D.fastProjectDataToRenderSpace(dArray3);
        double d = canvasSize.continueToMargin(dArray4, dArray2);
        sVGPath.moveTo(dArray4[0] + d * dArray2[0], dArray4[1] + d * dArray2[1]);
        dArray2[0] = dArray2[0] * -1.0;
        dArray2[1] = dArray2[1] * -1.0;
        d = canvasSize.continueToMargin(dArray4, dArray2);
        sVGPath.drawTo(dArray4[0] + d * dArray2[0], dArray4[1] + d * dArray2[1]);
        return sVGPath;
    }
}

