/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.visualizers.scatterplot.cluster;

import de.lmu.ifi.dbs.elki.data.Cluster;
import de.lmu.ifi.dbs.elki.data.Clustering;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.model.KMeansModel;
import de.lmu.ifi.dbs.elki.data.model.MedoidModel;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.math.geometry.SweepHullDelaunay2D;
import de.lmu.ifi.dbs.elki.math.linearalgebra.Vector;
import de.lmu.ifi.dbs.elki.utilities.datastructures.hierarchy.Hierarchy;
import de.lmu.ifi.dbs.elki.utilities.exceptions.ObjectNotFoundException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.EnumParameter;
import de.lmu.ifi.dbs.elki.visualization.VisualizationMenuAction;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTask;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTree;
import de.lmu.ifi.dbs.elki.visualization.VisualizerContext;
import de.lmu.ifi.dbs.elki.visualization.css.CSSClass;
import de.lmu.ifi.dbs.elki.visualization.gui.VisualizationPlot;
import de.lmu.ifi.dbs.elki.visualization.projections.Projection;
import de.lmu.ifi.dbs.elki.visualization.projector.ScatterPlotProjector;
import de.lmu.ifi.dbs.elki.visualization.style.ClusterStylingPolicy;
import de.lmu.ifi.dbs.elki.visualization.style.StyleLibrary;
import de.lmu.ifi.dbs.elki.visualization.style.StylingPolicy;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGPath;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGPlot;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGUtil;
import de.lmu.ifi.dbs.elki.visualization.svg.VoronoiDraw;
import de.lmu.ifi.dbs.elki.visualization.visualizers.AbstractVisFactory;
import de.lmu.ifi.dbs.elki.visualization.visualizers.Visualization;
import de.lmu.ifi.dbs.elki.visualization.visualizers.scatterplot.AbstractScatterplotVisualization;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class VoronoiVisualization
extends AbstractVisFactory {
    private static final String NAME = "k-means Voronoi cells";
    private static final String KMEANSBORDER = "kmeans-border";
    private Mode mode;

    public VoronoiVisualization(Mode mode) {
        this.mode = mode;
    }

    @Override
    public Visualization makeVisualization(VisualizationTask visualizationTask, VisualizationPlot visualizationPlot, double d, double d2, Projection projection) {
        return new Instance(visualizationTask, visualizationPlot, d, d2, projection);
    }

    @Override
    public void processNewResult(VisualizerContext visualizerContext, Object object) {
        Hierarchy.Iter<ScatterPlotProjector> iter = VisualizationTree.filter(visualizerContext, object, ScatterPlotProjector.class);
        while (iter.valid()) {
            ScatterPlotProjector scatterPlotProjector = iter.get();
            VisualizationTask visualizationTask = new VisualizationTask(NAME, visualizerContext, scatterPlotProjector, scatterPlotProjector.getRelation(), this);
            visualizationTask.level = 103;
            visualizationTask.addUpdateFlags(4);
            visualizerContext.addVis(scatterPlotProjector, visualizationTask);
            visualizerContext.addVis(scatterPlotProjector, new SwitchModeAction(visualizationTask, visualizerContext));
            iter.advance();
        }
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID MODE_ID = new OptionID("voronoi.mode", "Mode for drawing the voronoi cells (and/or delaunay triangulation)");
        protected Mode mode;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            super.makeOptions(parameterization);
            EnumParameter<Mode> enumParameter = new EnumParameter<Mode>(MODE_ID, Mode.class, Mode.VORONOI);
            if (parameterization.grab(enumParameter)) {
                this.mode = (Mode)((Object)enumParameter.getValue());
            }
        }

        @Override
        protected VoronoiVisualization makeInstance() {
            return new VoronoiVisualization(this.mode);
        }
    }

    public class Instance
    extends AbstractScatterplotVisualization {
        Element voronoi;

        public Instance(VisualizationTask visualizationTask, VisualizationPlot visualizationPlot, double d, double d2, Projection projection) {
            super(visualizationTask, visualizationPlot, d, d2, projection);
            this.addListeners();
        }

        @Override
        public void fullRedraw() {
            Object object;
            this.setupCanvas();
            StylingPolicy stylingPolicy = this.context.getStylingPolicy();
            if (!(stylingPolicy instanceof ClusterStylingPolicy)) {
                return;
            }
            Clustering<?> clustering = ((ClusterStylingPolicy)stylingPolicy).getClustering();
            if (clustering.getAllClusters().size() <= 1) {
                return;
            }
            int n = this.proj.getInputDimensionality();
            if (n != 2) {
                return;
            }
            this.addCSSClasses(this.svgp);
            List<Cluster<?>> list = clustering.getAllClusters();
            ArrayList<Vector> arrayList = new ArrayList<Vector>(list.size());
            ArrayList<double[]> arrayList2 = new ArrayList<double[]>(list.size());
            for (Cluster<?> object2 : list) {
                Vector vector;
                Object obj = object2.getModel();
                try {
                    Object object3;
                    if (obj instanceof KMeansModel) {
                        object3 = ((KMeansModel)obj).getMean();
                        if (object3 == null || (vector = ((Vector)object3).getColumnVector()).getDimensionality() != n) {
                        }
                    } else {
                        NumberVector numberVector;
                        if (!(obj instanceof MedoidModel) || (object3 = ((MedoidModel)obj).getMedoid()) == null || (numberVector = (NumberVector)this.rel.get((DBIDRef)object3)) == null) continue;
                        vector = numberVector.getColumnVector();
                        if (vector.getDimensionality() != n) {
                        }
                    }
                }
                catch (ObjectNotFoundException objectNotFoundException) {}
                continue;
                arrayList.add(vector);
                arrayList2.add(vector.getArrayRef());
            }
            if (arrayList2.size() < 2) {
                return;
            }
            if (arrayList2.size() == 2) {
                if (VoronoiVisualization.this.mode == Mode.VORONOI || VoronoiVisualization.this.mode == Mode.V_AND_D) {
                    object = VoronoiDraw.drawFakeVoronoi(this.proj, arrayList2).makeElement(this.svgp);
                    SVGUtil.addCSSClass((Element)object, VoronoiVisualization.KMEANSBORDER);
                    this.layer.appendChild((Node)object);
                }
                if (VoronoiVisualization.this.mode == Mode.DELAUNAY || VoronoiVisualization.this.mode == Mode.V_AND_D) {
                    object = new SVGPath(this.proj.fastProjectDataToRenderSpace(arrayList2.get(0))).drawTo(this.proj.fastProjectDataToRenderSpace(arrayList2.get(1))).makeElement(this.svgp);
                    SVGUtil.addCSSClass((Element)object, VoronoiVisualization.KMEANSBORDER);
                    this.layer.appendChild((Node)object);
                }
            } else {
                object = new SweepHullDelaunay2D(arrayList).getDelaunay();
                if (VoronoiVisualization.this.mode == Mode.VORONOI || VoronoiVisualization.this.mode == Mode.V_AND_D) {
                    Element element = VoronoiDraw.drawVoronoi(this.proj, (List<SweepHullDelaunay2D.Triangle>)object, arrayList2).makeElement(this.svgp);
                    SVGUtil.addCSSClass(element, VoronoiVisualization.KMEANSBORDER);
                    this.layer.appendChild(element);
                }
                if (VoronoiVisualization.this.mode == Mode.DELAUNAY || VoronoiVisualization.this.mode == Mode.V_AND_D) {
                    Element element = VoronoiDraw.drawDelaunay(this.proj, (List<SweepHullDelaunay2D.Triangle>)object, arrayList2).makeElement(this.svgp);
                    SVGUtil.addCSSClass(element, VoronoiVisualization.KMEANSBORDER);
                    this.layer.appendChild(element);
                }
            }
        }

        private void addCSSClasses(SVGPlot sVGPlot) {
            if (!sVGPlot.getCSSClassManager().contains(VoronoiVisualization.KMEANSBORDER)) {
                StyleLibrary styleLibrary = this.context.getStyleLibrary();
                CSSClass cSSClass = new CSSClass(this, VoronoiVisualization.KMEANSBORDER);
                cSSClass = new CSSClass(this, VoronoiVisualization.KMEANSBORDER);
                cSSClass.setStatement("stroke", "black");
                cSSClass.setStatement("stroke-width", styleLibrary.getLineWidth("plot") * 0.5);
                cSSClass.setStatement("fill", "none");
                cSSClass.setStatement("stroke-linecap", "round");
                cSSClass.setStatement("stroke-linejoin", "round");
                sVGPlot.addCSSClassOrLogError(cSSClass);
            }
        }
    }

    public class SwitchModeAction
    implements VisualizationMenuAction {
        private VisualizationTask task;
        private VisualizerContext context;

        public SwitchModeAction(VisualizationTask visualizationTask, VisualizerContext visualizerContext) {
            this.task = visualizationTask;
            this.context = visualizerContext;
        }

        @Override
        public String getMenuName() {
            return "Switch Voronoi Mode";
        }

        @Override
        public void activate() {
            switch (VoronoiVisualization.this.mode) {
                case VORONOI: {
                    VoronoiVisualization.this.mode = Mode.DELAUNAY;
                    break;
                }
                case DELAUNAY: {
                    VoronoiVisualization.this.mode = Mode.V_AND_D;
                    break;
                }
                case V_AND_D: {
                    VoronoiVisualization.this.mode = Mode.VORONOI;
                }
            }
            this.context.visChanged(this.task);
        }

        @Override
        public boolean enabled() {
            return true;
        }
    }

    public static enum Mode {
        VORONOI,
        DELAUNAY,
        V_AND_D;

    }
}

