/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.visualizers.scatterplot.selection;

import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.UpdatableDatabase;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.math.linearalgebra.Vector;
import de.lmu.ifi.dbs.elki.result.ResultUtil;
import de.lmu.ifi.dbs.elki.utilities.datastructures.hierarchy.Hierarchy;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTask;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTree;
import de.lmu.ifi.dbs.elki.visualization.VisualizerContext;
import de.lmu.ifi.dbs.elki.visualization.batikutil.DragableArea;
import de.lmu.ifi.dbs.elki.visualization.css.CSSClass;
import de.lmu.ifi.dbs.elki.visualization.gui.VisualizationPlot;
import de.lmu.ifi.dbs.elki.visualization.projections.Projection;
import de.lmu.ifi.dbs.elki.visualization.projector.ScatterPlotProjector;
import de.lmu.ifi.dbs.elki.visualization.style.StyleLibrary;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGPlot;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGUtil;
import de.lmu.ifi.dbs.elki.visualization.visualizers.AbstractVisFactory;
import de.lmu.ifi.dbs.elki.visualization.visualizers.Visualization;
import de.lmu.ifi.dbs.elki.visualization.visualizers.scatterplot.AbstractScatterplotVisualization;
import org.w3c.dom.Element;
import org.w3c.dom.events.Event;
import org.w3c.dom.svg.SVGPoint;

public class MoveObjectsToolVisualization
extends AbstractVisFactory {
    private static final String NAME = "Move Objects";

    @Override
    public Visualization makeVisualization(VisualizationTask visualizationTask, VisualizationPlot visualizationPlot, double d, double d2, Projection projection) {
        return new Instance(visualizationTask, visualizationPlot, d, d2, projection);
    }

    @Override
    public void processNewResult(VisualizerContext visualizerContext, Object object) {
        Database database = ResultUtil.findDatabase(visualizerContext.getHierarchy());
        if (!(database instanceof UpdatableDatabase)) {
            return;
        }
        Hierarchy.Iter<ScatterPlotProjector> iter = VisualizationTree.filter(visualizerContext, object, ScatterPlotProjector.class);
        while (iter.valid()) {
            ScatterPlotProjector scatterPlotProjector = iter.get();
            Relation relation = scatterPlotProjector.getRelation();
            if (TypeUtil.NUMBER_VECTOR_FIELD.isAssignableFromType(relation.getDataTypeInformation())) {
                VisualizationTask visualizationTask = new VisualizationTask(NAME, visualizerContext, scatterPlotProjector.getRelation(), relation, this);
                visualizationTask.level = 1000;
                visualizationTask.tool = true;
                visualizationTask.addFlags(5);
                visualizationTask.addUpdateFlags(11);
                visualizationTask.initDefaultVisibility(false);
                visualizerContext.addVis(scatterPlotProjector, visualizationTask);
            }
            iter.advance();
        }
    }

    public class Instance
    extends AbstractScatterplotVisualization
    implements DragableArea.DragListener {
        protected static final String CSS_ARROW = "moveArrow";
        private Element etag;
        private Element rtag;

        public Instance(VisualizationTask visualizationTask, VisualizationPlot visualizationPlot, double d, double d2, Projection projection) {
            super(visualizationTask, visualizationPlot, d, d2, projection);
            this.addListeners();
        }

        @Override
        public void fullRedraw() {
            this.setupCanvas();
            this.addCSSClasses(this.svgp);
            this.rtag = this.svgp.svgElement("g");
            SVGUtil.addCSSClass(this.rtag, CSS_ARROW);
            this.layer.appendChild(this.rtag);
            DragableArea dragableArea = new DragableArea((SVGPlot)this.svgp, -60.0, -70.0, 130.0, 140.0, this);
            this.etag = dragableArea.getElement();
            this.layer.appendChild(this.etag);
        }

        private void updateDB(DBIDs dBIDs, Vector vector) {
            throw new AbortException("FIXME: INCOMPLETE TRANSITION");
        }

        private void deleteChildren(Element element) {
            while (element.hasChildNodes()) {
                element.removeChild(element.getLastChild());
            }
        }

        private void addCSSClasses(SVGPlot sVGPlot) {
            if (!sVGPlot.getCSSClassManager().contains(CSS_ARROW)) {
                CSSClass cSSClass = new CSSClass(this, CSS_ARROW);
                StyleLibrary styleLibrary = this.context.getStyleLibrary();
                cSSClass.setStatement("stroke", styleLibrary.getColor("plot.selection.active"));
                cSSClass.setStatement("stroke-width", styleLibrary.getLineWidth("plot.selection.active"));
                cSSClass.setStatement("stroke-linecap", "round");
                sVGPlot.addCSSClassOrLogError(cSSClass);
            }
        }

        @Override
        public boolean startDrag(SVGPoint sVGPoint, Event event) {
            return true;
        }

        @Override
        public boolean duringDrag(SVGPoint sVGPoint, SVGPoint sVGPoint2, Event event, boolean bl) {
            this.deleteChildren(this.rtag);
            this.rtag.appendChild(this.svgp.svgLine(sVGPoint.getX(), sVGPoint.getY(), sVGPoint2.getX(), sVGPoint2.getY()));
            return true;
        }

        @Override
        public boolean endDrag(SVGPoint sVGPoint, SVGPoint sVGPoint2, Event event, boolean bl) {
            Vector vector = new Vector(2);
            vector.set(0, sVGPoint2.getX() - sVGPoint.getX());
            vector.set(1, sVGPoint2.getY() - sVGPoint.getY());
            if (this.context.getSelection() != null) {
                this.updateDB(this.context.getSelection().getSelectedIds(), vector);
            }
            this.deleteChildren(this.rtag);
            return true;
        }
    }
}

