/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.flock.emc.wrappers;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.epsilon.common.util.CollectionUtil;
import org.eclipse.epsilon.flock.context.ConservativeCopyContext;
import org.eclipse.epsilon.flock.emc.wrappers.Model;
import org.eclipse.epsilon.flock.emc.wrappers.ModelValue;
import org.eclipse.epsilon.flock.execution.exceptions.ConservativeCopyException;

class CollectionOfModelValues
extends ModelValue<Collection<?>>
implements Iterable<ModelValue<?>> {
    private final Collection<ModelValue<?>> modelValues = new LinkedList();

    CollectionOfModelValues(Model model, Collection<ModelValue<?>> wrappedValues) {
        this.modelValues.addAll(wrappedValues);
    }

    CollectionOfModelValues(Model model, ModelValue<?> ... wrappedValues) {
        this(model, Arrays.asList(wrappedValues));
    }

    public CollectionOfModelValues getEquivalentIn(Model model, ConservativeCopyContext context) throws ConservativeCopyException {
        LinkedList copiedModelValues = new LinkedList();
        for (ModelValue<?> modelValue : this.modelValues) {
            ModelValue<?> equivalent = modelValue.getEquivalentIn(model, context);
            if (equivalent.unwrap() == null) continue;
            copiedModelValues.add(equivalent);
        }
        return new CollectionOfModelValues(model, copiedModelValues);
    }

    @Override
    public Collection<?> unwrap() {
        List modelObjects = CollectionUtil.createDefaultList();
        for (ModelValue<?> modelValue : this.modelValues) {
            modelObjects.add(modelValue.unwrap());
        }
        return modelObjects;
    }

    @Override
    public Iterator<ModelValue<?>> iterator() {
        return this.modelValues.iterator();
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof CollectionOfModelValues)) {
            return false;
        }
        return this.modelValues.equals(((CollectionOfModelValues)o).modelValues);
    }

    @Override
    public int hashCode() {
        return this.modelValues.hashCode();
    }

    @Override
    public String toString() {
        return this.modelValues.toString();
    }
}

