/*
 * Decompiled with CFR 0.152.
 */
package org.jgap.distr;

import java.io.Serializable;
import java.util.List;
import java.util.Vector;
import org.apache.commons.lang.builder.CompareToBuilder;
import org.jgap.distr.CultureMemoryCell;

public class Culture
implements Serializable,
Comparable {
    private static final String CVS_REVISION = "$Revision: 1.16 $";
    private CultureMemoryCell[] m_memory;
    private List m_memoryNames = new Vector();
    private int m_size;
    private int m_width;

    public Culture(int a_size) {
        if (a_size < 1) {
            throw new IllegalArgumentException("Size must be greater than zero!");
        }
        this.m_size = a_size;
        this.m_memory = new CultureMemoryCell[this.m_size];
        this.m_width = 1;
    }

    public CultureMemoryCell set(int a_index, double a_value, int a_historySize, String a_name) {
        if (a_index < 0 || a_index >= this.size()) {
            throw new IllegalArgumentException("Illegal memory index!");
        }
        CultureMemoryCell cell = new CultureMemoryCell(a_name, a_historySize);
        cell.setDouble(a_value);
        this.m_memory[a_index] = cell;
        return cell;
    }

    public CultureMemoryCell set(int a_index, Object a_value, int a_historySize, String a_infotext) {
        if (a_index < 0 || a_index >= this.size()) {
            throw new IllegalArgumentException("Illegal memory index!");
        }
        CultureMemoryCell cell = new CultureMemoryCell(a_infotext, a_historySize);
        cell.setValue(a_value);
        this.m_memory[a_index] = cell;
        return cell;
    }

    public CultureMemoryCell set(String a_name, Object a_value, int a_historySize) {
        if (a_name == null || a_name.length() < 1) {
            throw new IllegalArgumentException("Illegal memory name!");
        }
        int index = this.m_memoryNames.indexOf(a_name);
        if (index < 0) {
            this.m_memoryNames.add(a_name);
            index = this.m_memoryNames.size() - 1;
        }
        CultureMemoryCell cell = new CultureMemoryCell(a_name, a_historySize);
        cell.setValue(a_value);
        this.m_memory[index] = cell;
        return cell;
    }

    public CultureMemoryCell get(int a_index) {
        if (a_index < 0 || a_index >= this.size()) {
            throw new IllegalArgumentException("Illegal memory index!");
        }
        return this.m_memory[a_index];
    }

    public CultureMemoryCell get(String a_name) {
        if (a_name == null || a_name.length() < 1) {
            throw new IllegalArgumentException("Illegal memory name!");
        }
        int index = this.m_memoryNames.indexOf(a_name);
        if (index < 0) {
            throw new IllegalArgumentException("Memory name unknown: " + a_name);
        }
        return this.m_memory[index];
    }

    public boolean contains(String a_name) {
        if (a_name == null || a_name.length() < 1) {
            throw new IllegalArgumentException("Illegal memory name!");
        }
        int index = this.m_memoryNames.indexOf(a_name);
        return index >= 0;
    }

    public int size() {
        return this.m_memory.length;
    }

    public String toString() {
        StringBuffer result = new StringBuffer("[");
        int len = this.m_memory.length;
        if (this.m_memory[0] == null) {
            result.append(this.m_memory[0]);
        } else {
            result.append(this.m_memory[0].toString());
        }
        for (int i = 1; i < len; ++i) {
            if (this.m_memory[i] == null) {
                result.append(";" + this.m_memory[i]);
                continue;
            }
            result.append(";" + this.m_memory[i].toString());
        }
        result.append("]");
        return result.toString();
    }

    public void clear() {
        this.m_memory = new CultureMemoryCell[this.m_size];
        this.m_memoryNames.clear();
    }

    public List getMemoryNames() {
        return new Vector(this.m_memoryNames);
    }

    public boolean equals(Object a_other) {
        try {
            return this.compareTo(a_other) == 0;
        }
        catch (ClassCastException cex) {
            cex.printStackTrace();
            return false;
        }
    }

    public int compareTo(Object a_other) {
        Culture other = (Culture)a_other;
        if (other == null) {
            return 1;
        }
        return new CompareToBuilder().append(this.m_size, other.m_size).append((Object[])this.m_memory, (Object[])other.m_memory).append(this.m_memoryNames.toArray(), other.m_memoryNames.toArray()).toComparison();
    }

    public void setMatrixWidth(int a_width) {
        int size = this.size();
        if (a_width > size) {
            throw new IllegalArgumentException("Width must not be greater than the size of the memory (" + size + ") !");
        }
        this.m_width = a_width;
    }

    public CultureMemoryCell setMatrix(int a_x, int a_y, Object a_value) {
        int index = a_x * this.m_width + a_y;
        CultureMemoryCell cell = this.m_memory[index];
        if (cell == null) {
            cell = new CultureMemoryCell(a_x + "_" + a_y, -1);
        }
        cell.setValue(a_value);
        this.m_memory[index] = cell;
        return cell;
    }

    public CultureMemoryCell getMatrix(int a_x, int a_y) {
        int index = a_x * this.m_width + a_y;
        return this.get(index);
    }
}

