/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.lazy.kstar;

import weka.classifiers.lazy.kstar.KStarCache;
import weka.classifiers.lazy.kstar.KStarConstants;
import weka.classifiers.lazy.kstar.KStarWrapper;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;

public class KStarNumericAttribute
implements KStarConstants,
RevisionHandler {
    protected Instances m_TrainSet;
    protected Instance m_Test;
    protected Instance m_Train;
    protected int m_AttrIndex;
    protected double m_Scale = 1.0;
    protected double m_MissingProb = 1.0;
    protected double m_AverageProb = 1.0;
    protected double m_SmallestProb = 1.0;
    protected double[] m_Distances;
    protected int[][] m_RandClassCols;
    protected int m_ActualCount = 0;
    protected KStarCache m_Cache;
    protected int m_NumInstances;
    protected int m_NumClasses;
    protected int m_NumAttributes;
    protected int m_ClassType;
    protected int m_MissingMode = 4;
    protected int m_BlendMethod = 1;
    protected int m_BlendFactor = 20;

    public KStarNumericAttribute(Instance test, Instance train, int attrIndex, Instances trainSet, int[][] randClassCols, KStarCache cache) {
        this.m_Test = test;
        this.m_Train = train;
        this.m_AttrIndex = attrIndex;
        this.m_TrainSet = trainSet;
        this.m_RandClassCols = randClassCols;
        this.m_Cache = cache;
        this.init();
    }

    private void init() {
        try {
            this.m_NumInstances = this.m_TrainSet.numInstances();
            this.m_NumClasses = this.m_TrainSet.numClasses();
            this.m_NumAttributes = this.m_TrainSet.numAttributes();
            this.m_ClassType = this.m_TrainSet.classAttribute().type();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public double transProb() {
        double transProb;
        if (this.m_Cache.containsKey(this.m_Test.value(this.m_AttrIndex))) {
            KStarCache.TableEntry te = this.m_Cache.getCacheValues(this.m_Test.value(this.m_AttrIndex));
            this.m_Scale = te.value;
            this.m_MissingProb = te.pmiss;
        } else {
            this.m_Scale = this.m_BlendMethod == 2 ? this.scaleFactorUsingEntropy() : this.scaleFactorUsingBlend();
            this.m_Cache.store(this.m_Test.value(this.m_AttrIndex), this.m_Scale, this.m_MissingProb);
        }
        if (this.m_Train.isMissing(this.m_AttrIndex)) {
            transProb = this.m_MissingProb;
        } else {
            double distance = Math.abs(this.m_Test.value(this.m_AttrIndex) - this.m_Train.value(this.m_AttrIndex));
            transProb = this.PStar(distance, this.m_Scale);
        }
        return transProb;
    }

    private double scaleFactorUsingBlend() {
        double min_pos;
        double minprob;
        double avgprob;
        double scale;
        block23: {
            int lowestcount = 0;
            double lowest = -1.0;
            double nextlowest = -1.0;
            double min_val = 9.0E300;
            scale = 1.0;
            avgprob = 0.0;
            minprob = 0.0;
            min_pos = 0.0;
            KStarWrapper botvals = new KStarWrapper();
            KStarWrapper upvals = new KStarWrapper();
            KStarWrapper vals = new KStarWrapper();
            this.m_Distances = new double[this.m_NumInstances];
            int j = 0;
            while (j < this.m_NumInstances) {
                if (this.m_TrainSet.instance(j).isMissing(this.m_AttrIndex)) {
                    this.m_Distances[j] = -1.0;
                } else {
                    this.m_Distances[j] = Math.abs(this.m_TrainSet.instance(j).value(this.m_AttrIndex) - this.m_Test.value(this.m_AttrIndex));
                    if (this.m_Distances[j] + 1.0E-5 < nextlowest || nextlowest == -1.0) {
                        if (this.m_Distances[j] + 1.0E-5 < lowest || lowest == -1.0) {
                            nextlowest = lowest;
                            lowest = this.m_Distances[j];
                            lowestcount = 1;
                        } else if (Math.abs(this.m_Distances[j] - lowest) < 1.0E-5) {
                            ++lowestcount;
                        } else {
                            nextlowest = this.m_Distances[j];
                        }
                    }
                    ++this.m_ActualCount;
                }
                ++j;
            }
            if (nextlowest == -1.0 || lowest == -1.0) {
                scale = 1.0;
                this.m_AverageProb = 1.0;
                this.m_SmallestProb = 1.0;
                return scale;
            }
            double root = 1.0 / (nextlowest - lowest);
            int i = 0;
            double aimfor = (double)(this.m_ActualCount - lowestcount) * (double)this.m_BlendFactor / 100.0 + (double)lowestcount;
            if (this.m_BlendFactor == 0) {
                aimfor += 1.0;
            }
            double bot = 0.005;
            double up = root * 16.0;
            this.calculateSphereSize(bot, botvals);
            botvals.sphere -= aimfor;
            this.calculateSphereSize(up, upvals);
            upvals.sphere -= aimfor;
            if (botvals.sphere < 0.0) {
                min_pos = bot;
                avgprob = botvals.avgProb;
                minprob = botvals.minProb;
            } else if (upvals.sphere > 0.0) {
                min_pos = up;
                avgprob = upvals.avgProb;
                minprob = upvals.minProb;
            } else {
                do {
                    double broot;
                    this.calculateSphereSize(root, vals);
                    vals.sphere -= aimfor;
                    if (Math.abs(vals.sphere) < min_val) {
                        min_val = Math.abs(vals.sphere);
                        min_pos = root;
                        avgprob = vals.avgProb;
                        minprob = vals.minProb;
                    }
                    if (Math.abs(vals.sphere) <= 0.01) break block23;
                    if (vals.sphere > 0.0) {
                        broot = (root + up) / 2.0;
                        bot = root;
                        root = broot;
                        continue;
                    }
                    broot = (root + bot) / 2.0;
                    up = root;
                    root = broot;
                } while (++i <= 40);
                root = min_pos;
            }
        }
        this.m_SmallestProb = minprob;
        this.m_AverageProb = avgprob;
        switch (this.m_MissingMode) {
            case 1: {
                this.m_MissingProb = 0.0;
                break;
            }
            case 3: {
                this.m_MissingProb = 1.0;
                break;
            }
            case 2: {
                this.m_MissingProb = this.m_SmallestProb;
                break;
            }
            case 4: {
                this.m_MissingProb = this.m_AverageProb;
            }
        }
        scale = min_pos;
        return scale;
    }

    private void calculateSphereSize(double scale, KStarWrapper params) {
        double sphereSize;
        double minprob = 1.0;
        double pstarSum = 0.0;
        double pstarSquareSum = 0.0;
        int i = 0;
        while (i < this.m_NumInstances) {
            if (!(this.m_Distances[i] < 0.0)) {
                double pstar = this.PStar(this.m_Distances[i], scale);
                if (minprob > pstar) {
                    minprob = pstar;
                }
                double inc = pstar / (double)this.m_ActualCount;
                pstarSum += inc;
                pstarSquareSum += inc * inc;
            }
            ++i;
        }
        params.sphere = sphereSize = pstarSquareSum == 0.0 ? 0.0 : pstarSum * pstarSum / pstarSquareSum;
        params.avgProb = pstarSum;
        params.minProb = minprob;
    }

    private double scaleFactorUsingEntropy() {
        String debug = "(KStarNumericAttribute.scaleFactorUsingEntropy)";
        if (this.m_ClassType != 1) {
            System.err.println("Error: " + debug + " attribute class must be nominal!");
            System.exit(1);
        }
        double lowest = -1.0;
        double nextlowest = -1.0;
        double scale = 1.0;
        KStarWrapper botvals = new KStarWrapper();
        KStarWrapper upvals = new KStarWrapper();
        KStarWrapper vals = new KStarWrapper();
        this.m_Distances = new double[this.m_NumInstances];
        int j = 0;
        while (j < this.m_NumInstances) {
            if (this.m_TrainSet.instance(j).isMissing(this.m_AttrIndex)) {
                this.m_Distances[j] = -1.0;
            } else {
                this.m_Distances[j] = Math.abs(this.m_TrainSet.instance(j).value(this.m_AttrIndex) - this.m_Test.value(this.m_AttrIndex));
                if (this.m_Distances[j] + 1.0E-5 < nextlowest || nextlowest == -1.0) {
                    if (this.m_Distances[j] + 1.0E-5 < lowest || lowest == -1.0) {
                        nextlowest = lowest;
                        lowest = this.m_Distances[j];
                    } else if (!(Math.abs(this.m_Distances[j] - lowest) < 1.0E-5)) {
                        nextlowest = this.m_Distances[j];
                    }
                }
                ++this.m_ActualCount;
            }
            ++j;
        }
        if (nextlowest == -1.0 || lowest == -1.0) {
            scale = 1.0;
            this.m_AverageProb = 1.0;
            this.m_SmallestProb = 1.0;
            return scale;
        }
        double root = 1.0 / (nextlowest - lowest);
        double bot = 0.005;
        double up = root * 8.0;
        this.calculateEntropy(up, upvals);
        this.calculateEntropy(bot, botvals);
        double randscale = botvals.randEntropy - upvals.randEntropy;
        double bestroot = root = bot;
        double currentdiff = 0.1;
        double bestdiff = 0.1;
        double bestpsum = botvals.avgProb;
        double bestminprob = botvals.minProb;
        double stepsize = (up - bot) / 20.0;
        int itcount = 0;
        do {
            double delta;
            ++itcount;
            double lastdiff = currentdiff;
            if ((root += Math.log(root + 1.0) * stepsize) <= bot) {
                root = bot;
                currentdiff = 0.0;
                delta = -1.0;
            } else if (root >= up) {
                root = up;
                currentdiff = 0.0;
                delta = -1.0;
            } else {
                this.calculateEntropy(root, vals);
                vals.randEntropy = (vals.randEntropy - upvals.randEntropy) / randscale;
                vals.actEntropy = (vals.actEntropy - upvals.actEntropy) / randscale;
                currentdiff = vals.randEntropy - vals.actEntropy;
                if (currentdiff < 0.1) {
                    currentdiff = 0.1;
                    if (stepsize < 0.0) {
                        bestdiff = currentdiff;
                        bestroot = bot;
                        bestpsum = botvals.avgProb;
                        bestminprob = botvals.minProb;
                        break;
                    }
                }
                delta = currentdiff - lastdiff;
            }
            if (currentdiff > bestdiff) {
                bestdiff = currentdiff;
                bestroot = root;
                bestminprob = vals.minProb;
                bestpsum = vals.avgProb;
            }
            if (!(delta < 0.0)) continue;
            if (Math.abs(stepsize) < 0.01) break;
            stepsize /= -4.0;
        } while (itcount <= 40);
        this.m_SmallestProb = bestminprob;
        this.m_AverageProb = bestpsum;
        switch (this.m_MissingMode) {
            case 1: {
                this.m_MissingProb = 0.0;
                break;
            }
            case 3: {
                this.m_MissingProb = 1.0;
                break;
            }
            case 2: {
                this.m_MissingProb = this.m_SmallestProb;
                break;
            }
            case 4: {
                this.m_MissingProb = this.m_AverageProb;
            }
        }
        scale = bestroot;
        return scale;
    }

    private void calculateEntropy(double scale, KStarWrapper params) {
        int k;
        int i;
        double actent = 0.0;
        double randent = 0.0;
        double avgprob = 0.0;
        double minprob = 1.0;
        double[][] pseudoClassProbs = new double[6][this.m_NumClasses];
        int j = 0;
        while (j <= 5) {
            i = 0;
            while (i < this.m_NumClasses) {
                pseudoClassProbs[j][i] = 0.0;
                ++i;
            }
            ++j;
        }
        i = 0;
        while (i < this.m_NumInstances) {
            if (!(this.m_Distances[i] < 0.0)) {
                double pstar = this.PStar(this.m_Distances[i], scale);
                double tprob = pstar / (double)this.m_ActualCount;
                avgprob += tprob;
                if (pstar < minprob) {
                    minprob = pstar;
                }
                k = 0;
                while (k <= 5) {
                    double[] dArray = pseudoClassProbs[k];
                    int n = this.m_RandClassCols[k][i];
                    dArray[n] = dArray[n] + tprob;
                    ++k;
                }
            }
            ++i;
        }
        j = this.m_NumClasses - 1;
        while (j >= 0) {
            double actClassProb = pseudoClassProbs[5][j] / avgprob;
            if (actClassProb > 0.0) {
                actent -= actClassProb * Math.log(actClassProb) / 0.693147181;
            }
            --j;
        }
        k = 0;
        while (k < 5) {
            i = this.m_NumClasses - 1;
            while (i >= 0) {
                double randClassProb = pseudoClassProbs[k][i] / avgprob;
                if (randClassProb > 0.0) {
                    randent -= randClassProb * Math.log(randClassProb) / 0.693147181;
                }
                --i;
            }
            ++k;
        }
        params.actEntropy = actent;
        params.randEntropy = randent /= 5.0;
        params.avgProb = avgprob;
        params.minProb = minprob;
    }

    private double PStar(double x, double scale) {
        return scale * Math.exp(-2.0 * x * scale);
    }

    public void setOptions(int missingmode, int blendmethod, int blendfactor) {
        this.m_MissingMode = missingmode;
        this.m_BlendMethod = blendmethod;
        this.m_BlendFactor = blendfactor;
    }

    public void setMissingMode(int mode) {
        this.m_MissingMode = mode;
    }

    public void setBlendMethod(int method) {
        this.m_BlendMethod = method;
    }

    public void setBlendFactor(int factor) {
        this.m_BlendFactor = factor;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 10153 $");
    }
}

