/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.outlier.clustering;

import de.lmu.ifi.dbs.elki.algorithm.AbstractAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.clustering.em.EM;
import de.lmu.ifi.dbs.elki.algorithm.outlier.OutlierAlgorithm;
import de.lmu.ifi.dbs.elki.data.Clustering;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDoubleDataStore;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.relation.DoubleRelation;
import de.lmu.ifi.dbs.elki.database.relation.MaterializedDoubleRelation;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierResult;
import de.lmu.ifi.dbs.elki.result.outlier.ProbabilisticOutlierScore;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.ClassGenericsUtil;
import de.lmu.ifi.dbs.elki.utilities.datastructures.hierarchy.Hierarchy;
import de.lmu.ifi.dbs.elki.utilities.documentation.Description;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;

@Title(value="EM Outlier: Outlier Detection based on the generic EM clustering")
@Description(value="The outlier score assigned is based on the highest cluster probability obtained from EM clustering.")
@Alias(value={"de.lmu.ifi.dbs.elki.algorithm.outlier.EMOutlier"})
public class EMOutlier<V extends NumberVector>
extends AbstractAlgorithm<OutlierResult>
implements OutlierAlgorithm {
    private static final Logging LOG = Logging.getLogger(EMOutlier.class);
    private EM<V, ?> emClustering;

    public EMOutlier(EM<V, ?> eM) {
        this.emClustering = eM;
    }

    public OutlierResult run(Database database, Relation<V> relation) {
        this.emClustering.setSoft(true);
        Clustering<?> clustering = this.emClustering.run(database, relation);
        Relation relation2 = null;
        Hierarchy.Iter<Clustering<?>> iter = clustering.getHierarchy().iterChildren(clustering);
        while (iter.valid()) {
            if (iter.get() instanceof Relation && ((Relation)((Object)iter.get())).getDataTypeInformation() == EM.SOFT_TYPE) {
                Relation relation3;
                relation2 = relation3 = (Relation)((Object)iter.get());
            }
            iter.advance();
        }
        double d = 0.0;
        WritableDoubleDataStore writableDoubleDataStore = DataStoreUtil.makeDoubleStorage(relation.getDBIDs(), 3);
        Object object = relation.iterDBIDs();
        while (object.valid()) {
            double[] dArray;
            double d2 = Double.POSITIVE_INFINITY;
            for (double d3 : dArray = (double[])relation2.get((DBIDRef)object)) {
                d2 = Math.min(1.0 - d3, d2);
            }
            writableDoubleDataStore.putDouble((DBIDRef)object, d2);
            d = Math.max(d2, d);
            object.advance();
        }
        object = new MaterializedDoubleRelation("EM outlier scores", "em-outlier", writableDoubleDataStore, relation.getDBIDs());
        ProbabilisticOutlierScore probabilisticOutlierScore = new ProbabilisticOutlierScore(0.0, d);
        OutlierResult outlierResult = new OutlierResult(probabilisticOutlierScore, (DoubleRelation)object);
        outlierResult.addChildResult(clustering);
        return outlierResult;
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(TypeUtil.NUMBER_VECTOR_FIELD);
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<V extends NumberVector>
    extends AbstractParameterizer {
        protected EM<V, ?> em;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            super.makeOptions(parameterization);
            Class clazz = ClassGenericsUtil.uglyCastIntoSubclass(EM.class);
            this.em = (EM)parameterization.tryInstantiate(clazz);
        }

        @Override
        protected EMOutlier<V> makeInstance() {
            return new EMOutlier<V>(this.em);
        }
    }
}

