/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.distribution;

import de.lmu.ifi.dbs.elki.math.random.RandomFactory;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.AbstractDistribution;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import java.util.Random;

@Alias(value={"DoubleExponentialDistribution"})
public class LaplaceDistribution
extends AbstractDistribution {
    double rate;
    double location;

    public LaplaceDistribution(double d) {
        this(d, 0.0, (Random)null);
    }

    public LaplaceDistribution(double d, double d2) {
        this(d, d2, (Random)null);
    }

    public LaplaceDistribution(double d, Random random) {
        this(d, 0.0, random);
    }

    public LaplaceDistribution(double d, double d2, Random random) {
        super(random);
        this.rate = d;
        this.location = d2;
    }

    public LaplaceDistribution(double d, double d2, RandomFactory randomFactory) {
        super(randomFactory);
        this.rate = d;
        this.location = d2;
    }

    @Override
    public double pdf(double d) {
        return 0.5 * this.rate * Math.exp(-this.rate * Math.abs(d - this.location));
    }

    public static double pdf(double d, double d2) {
        return 0.5 * d2 * Math.exp(-d2 * Math.abs(d));
    }

    @Override
    public double cdf(double d) {
        double d2 = 0.5 * Math.exp(-this.rate * (d - this.location));
        return d < this.location ? d2 : 1.0 - d2;
    }

    public static double cdf(double d, double d2) {
        double d3 = 0.5 * Math.exp(-d2 * d);
        return d < 0.0 ? d3 : 1.0 - d3;
    }

    @Override
    public double quantile(double d) {
        if (d < 0.5) {
            return Math.log(2.0 * d) / this.rate + this.location;
        }
        return -Math.log(2.0 - 2.0 * d) / this.rate + this.location;
    }

    public static double quantile(double d, double d2, double d3) {
        if (d < 0.5) {
            return Math.log(2.0 * d) / d2 + d3;
        }
        return -Math.log(2.0 - 2.0 * d) / d2 + d3;
    }

    @Override
    public double nextRandom() {
        double d = this.random.nextDouble();
        if (d < 0.5) {
            return Math.log(2.0 * d) / this.rate + this.location;
        }
        return -Math.log(2.0 - 2.0 * d) / this.rate + this.location;
    }

    @Override
    public String toString() {
        return "LaplaceDistribution(rate=" + this.rate + ", location=" + this.location + ")";
    }

    public static class Parameterizer
    extends AbstractDistribution.Parameterizer {
        public static final OptionID RATE_ID = new OptionID("distribution.laplace.rate", "Laplace distribution rate (lambda) parameter (inverse of scale).");
        double location;
        double rate;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            DoubleParameter doubleParameter;
            super.makeOptions(parameterization);
            DoubleParameter doubleParameter2 = new DoubleParameter(LOCATION_ID);
            if (parameterization.grab(doubleParameter2)) {
                this.location = doubleParameter2.doubleValue();
            }
            if (parameterization.grab(doubleParameter = new DoubleParameter(RATE_ID))) {
                this.rate = doubleParameter.doubleValue();
            }
        }

        @Override
        protected LaplaceDistribution makeInstance() {
            return new LaplaceDistribution(this.rate, this.location, this.rnd);
        }
    }
}

