/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.gdbscan;

import de.lmu.ifi.dbs.elki.algorithm.DistanceBasedAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.clustering.DBSCAN;
import de.lmu.ifi.dbs.elki.algorithm.clustering.gdbscan.NeighborPredicate;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.database.datastore.DataStore;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDataStore;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDList;
import de.lmu.ifi.dbs.elki.database.query.range.RangeQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski.EuclideanDistanceFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.logging.statistics.Duration;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;

public abstract class AbstractRangeQueryNeighborPredicate<O, M>
implements NeighborPredicate {
    protected double epsilon;
    protected DistanceFunction<? super O> distFunc;

    public AbstractRangeQueryNeighborPredicate(double d, DistanceFunction<? super O> distanceFunction) {
        this.epsilon = d;
        this.distFunc = distanceFunction;
    }

    @Override
    public TypeInformation getInputTypeRestriction() {
        return this.distFunc.getInputTypeRestriction();
    }

    public DataStore<M> preprocess(Class<? super M> clazz, Relation<O> relation, RangeQuery<O> rangeQuery) {
        WritableDataStore<M> writableDataStore = DataStoreUtil.makeStorage(relation.getDBIDs(), 3, clazz);
        Duration duration = this.getLogger().newDuration(this.getClass().getName() + ".preprocessing-time").begin();
        FiniteProgress finiteProgress = this.getLogger().isVerbose() ? new FiniteProgress(this.getClass().getName(), relation.size(), this.getLogger()) : null;
        DBIDIter dBIDIter = relation.iterDBIDs();
        while (dBIDIter.valid()) {
            DoubleDBIDList doubleDBIDList = rangeQuery.getRangeForDBID(dBIDIter, this.epsilon);
            writableDataStore.put(dBIDIter, this.computeLocalModel(dBIDIter, doubleDBIDList, relation));
            this.getLogger().incrementProcessed(finiteProgress);
            dBIDIter.advance();
        }
        this.getLogger().ensureCompleted(finiteProgress);
        this.getLogger().statistics(duration.end());
        return writableDataStore;
    }

    protected abstract M computeLocalModel(DBIDRef var1, DoubleDBIDList var2, Relation<O> var3);

    abstract Logging getLogger();

    public static abstract class Parameterizer<O>
    extends AbstractParameterizer {
        double epsilon;
        DistanceFunction<O> distfun = null;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            super.makeOptions(parameterization);
            this.configDistance(parameterization);
            this.configEpsilon(parameterization);
        }

        protected void configDistance(Parameterization parameterization) {
            ObjectParameter objectParameter = new ObjectParameter(DistanceBasedAlgorithm.DISTANCE_FUNCTION_ID, (Class<?>)DistanceFunction.class, EuclideanDistanceFunction.class);
            if (parameterization.grab(objectParameter)) {
                this.distfun = (DistanceFunction)objectParameter.instantiateClass(parameterization);
            }
        }

        protected void configEpsilon(Parameterization parameterization) {
            DoubleParameter doubleParameter = new DoubleParameter(DBSCAN.Parameterizer.EPSILON_ID);
            if (parameterization.grab(doubleParameter)) {
                this.epsilon = (Double)doubleParameter.getValue();
            }
        }
    }

    public static abstract class Instance<N, M>
    implements NeighborPredicate.Instance<N> {
        protected DBIDs ids;
        protected DataStore<M> storage;

        public Instance(DBIDs dBIDs, DataStore<M> dataStore) {
            this.ids = dBIDs;
            this.storage = dataStore;
        }

        @Override
        public DBIDs getIDs() {
            return this.ids;
        }
    }
}

