/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.hierarchical;

import de.lmu.ifi.dbs.elki.algorithm.clustering.hierarchical.PointerHierarchyRepresentationResult;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDBIDDataStore;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDoubleDataStore;
import de.lmu.ifi.dbs.elki.database.datastore.WritableIntegerDataStore;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.logging.Logging;

public class PointerHierarchyRepresentationBuilder {
    private static final Logging LOG = Logging.getLogger(PointerHierarchyRepresentationBuilder.class);
    protected final DBIDs ids;
    protected WritableDBIDDataStore parent;
    protected WritableDoubleDataStore parentDistance;
    protected double prevdist;
    protected WritableIntegerDataStore csize;

    public PointerHierarchyRepresentationBuilder(DBIDs dBIDs) {
        this.ids = dBIDs;
        this.parent = DataStoreUtil.makeDBIDStorage(dBIDs, 30);
        this.parentDistance = DataStoreUtil.makeDoubleStorage(dBIDs, 30, Double.POSITIVE_INFINITY);
        this.prevdist = Double.NEGATIVE_INFINITY;
        DBIDIter dBIDIter = dBIDs.iter();
        while (dBIDIter.valid()) {
            this.parent.put((DBIDRef)dBIDIter, dBIDIter);
            dBIDIter.advance();
        }
    }

    public void add(DBIDRef dBIDRef, double d, DBIDRef dBIDRef2) {
        if (d < this.prevdist) {
            LOG.warning("Non-monotone hierarchical clustering detected. Adjusting linking distance from " + d + " to " + this.prevdist);
            d = this.prevdist;
        }
        this.parent.putDBID(dBIDRef, dBIDRef2);
        double d2 = this.parentDistance.putDouble(dBIDRef, d);
        assert (d2 == Double.POSITIVE_INFINITY) : "Object was already linked!";
        this.prevdist = d;
    }

    public PointerHierarchyRepresentationResult complete() {
        if (this.csize != null) {
            this.csize.destroy();
            this.csize = null;
        }
        return new PointerHierarchyRepresentationResult(this.ids, this.parent, this.parentDistance);
    }

    public int getSize(DBIDRef dBIDRef) {
        if (this.csize == null) {
            this.csize = DataStoreUtil.makeIntegerStorage(this.ids, 3, 1);
        }
        return this.csize.intValue(dBIDRef);
    }

    public void setSize(DBIDRef dBIDRef, int n) {
        if (this.csize == null) {
            this.csize = DataStoreUtil.makeIntegerStorage(this.ids, 3, 1);
        }
        this.csize.putInt(dBIDRef, n);
    }

    public boolean isLinked(DBIDRef dBIDRef) {
        return this.parentDistance.doubleValue(dBIDRef) < Double.POSITIVE_INFINITY;
    }

    public double getDistance(DBIDRef dBIDRef) {
        return this.parentDistance.doubleValue(dBIDRef);
    }
}

