/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.application.jsmap;

import com.sun.net.httpserver.Headers;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import de.lmu.ifi.dbs.elki.algorithm.outlier.spatial.neighborhood.NeighborSetPredicate;
import de.lmu.ifi.dbs.elki.application.jsmap.JSONBuffer;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.spatial.Polygon;
import de.lmu.ifi.dbs.elki.data.spatial.PolygonsObject;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.ids.DBID;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayMIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.relation.DoubleRelation;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.datasource.bundle.SingleObjectBundle;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.math.linearalgebra.Vector;
import de.lmu.ifi.dbs.elki.result.Result;
import de.lmu.ifi.dbs.elki.result.ResultHierarchy;
import de.lmu.ifi.dbs.elki.result.ResultUtil;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierResult;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierScoreMeta;
import de.lmu.ifi.dbs.elki.utilities.datastructures.hierarchy.Hierarchy;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.URLDecoder;
import java.util.concurrent.Executors;

public class JSONWebServer
implements HttpHandler {
    private static final Logging LOG = Logging.getLogger(JSONWebServer.class);
    public static final String PATH_JSON = "/json/";
    private HttpServer server;
    private ResultHierarchy hier;
    private Result baseResult;
    private Database db;

    public JSONWebServer(int n, ResultHierarchy resultHierarchy, Result result) {
        this.hier = resultHierarchy;
        this.baseResult = result;
        assert (resultHierarchy != null) : "MapWebServer created with null result.";
        this.db = ResultUtil.findDatabase(resultHierarchy);
        try {
            InetSocketAddress inetSocketAddress = new InetSocketAddress(n);
            this.server = HttpServer.create(inetSocketAddress, 0);
            this.server.createContext(PATH_JSON, this);
            this.server.setExecutor(Executors.newCachedThreadPool());
            this.server.start();
            LOG.verbose("Webserver started on port " + n + ".");
        }
        catch (IOException iOException) {
            throw new AbortException("Could not start mini web server.", iOException);
        }
    }

    public void stop() {
        this.server.stop(0);
    }

    private DBID stringToDBID(String string) {
        return DBIDUtil.importInteger(Integer.valueOf(string));
    }

    protected void bundleToJSON(JSONBuffer jSONBuffer, DBIDRef dBIDRef) {
        SingleObjectBundle singleObjectBundle = this.db.getBundle(dBIDRef);
        if (singleObjectBundle != null) {
            for (int i = 0; i < singleObjectBundle.metaLength(); ++i) {
                Object object = singleObjectBundle.data(i);
                if (object instanceof NumberVector) {
                    NumberVector numberVector = (NumberVector)object;
                    jSONBuffer.appendKeyArray(singleObjectBundle.meta(i));
                    for (int j = 0; j < numberVector.getDimensionality(); ++j) {
                        jSONBuffer.append(numberVector.doubleValue(j));
                    }
                    jSONBuffer.closeArray();
                } else if (object instanceof PolygonsObject) {
                    jSONBuffer.appendKeyArray(singleObjectBundle.meta(i));
                    for (Polygon polygon : ((PolygonsObject)object).getPolygons()) {
                        jSONBuffer.startArray();
                        for (int j = 0; j < polygon.size(); ++j) {
                            Vector vector = polygon.get(j);
                            jSONBuffer.append(vector.getArrayRef());
                        }
                        jSONBuffer.closeArray();
                    }
                    jSONBuffer.closeArray();
                } else {
                    jSONBuffer.appendKeyValue(singleObjectBundle.meta(i), object);
                }
                if (!LOG.isDebuggingFiner()) continue;
                jSONBuffer.appendNewline();
            }
        } else {
            jSONBuffer.appendKeyValue("error", "Object not found.");
        }
    }

    protected void resultToJSON(JSONBuffer jSONBuffer, String string) {
        Object object;
        Object object2;
        int n;
        String[] stringArray = string.split("/");
        Result result = this.baseResult;
        for (n = 0; n < stringArray.length; ++n) {
            boolean bl = false;
            object2 = this.hier.iterChildren(result);
            while (object2.valid()) {
                object = object2.get();
                if (object.getLongName().equals(stringArray[n]) || object.getShortName().equals(stringArray[n])) {
                    result = object;
                    bl = true;
                    break;
                }
                object2.advance();
            }
            if (!bl) break;
        }
        if (result == null) {
            jSONBuffer.appendKeyValue("error", "result not found.");
            return;
        }
        if (stringArray.length == n + 1 && "children".equals(stringArray[n])) {
            jSONBuffer.appendKeyArray("children");
            Hierarchy.Iter<Result> iter = this.hier.iterChildren(result);
            while (iter.valid()) {
                object2 = iter.get();
                jSONBuffer.startHash();
                jSONBuffer.appendKeyValue("name", object2.getShortName());
                jSONBuffer.appendKeyValue("type", object2.getClass().getSimpleName());
                jSONBuffer.closeHash();
                iter.advance();
            }
            jSONBuffer.closeArray();
            return;
        }
        if (result instanceof Database && stringArray.length == n + 1) {
            DBID dBID = this.stringToDBID(stringArray[n]);
            if (dBID != null) {
                this.bundleToJSON(jSONBuffer, dBID);
                return;
            }
            jSONBuffer.appendKeyValue("error", "Object not found");
            return;
        }
        if (result instanceof Relation && stringArray.length == n + 1) {
            Relation relation = (Relation)result;
            object2 = this.stringToDBID(stringArray[n]);
            if (object2 != null) {
                object = relation.get((DBIDRef)object2);
                jSONBuffer.appendKeyValue("data", object);
            } else {
                jSONBuffer.appendKeyValue("error", "Object not found");
                return;
            }
        }
        if (result instanceof NeighborSetPredicate && stringArray.length == n + 1) {
            NeighborSetPredicate neighborSetPredicate = (NeighborSetPredicate)result;
            object2 = this.stringToDBID(stringArray[n]);
            if (object2 != null) {
                object = neighborSetPredicate.getNeighborDBIDs((DBIDRef)object2);
                jSONBuffer.appendKeyValue("DBID", object2);
                jSONBuffer.appendKeyArray("neighbors");
                DBIDIter dBIDIter = object.iter();
                while (dBIDIter.valid()) {
                    jSONBuffer.appendString(dBIDIter.toString());
                    dBIDIter.advance();
                }
                jSONBuffer.closeArray();
                return;
            }
            jSONBuffer.appendKeyValue("error", "Object not found");
            return;
        }
        if (result instanceof OutlierResult) {
            OutlierResult outlierResult = (OutlierResult)result;
            if (stringArray.length >= n + 1 && "table".equals(stringArray[n])) {
                int n2;
                int n3 = 0;
                int n4 = 100;
                if (stringArray.length >= n + 2) {
                    n3 = Integer.valueOf(stringArray[n + 1]);
                }
                if (stringArray.length >= n + 3) {
                    n4 = Integer.valueOf(stringArray[n + 2]);
                }
                jSONBuffer.appendKeyHash("paging");
                jSONBuffer.appendKeyValue("offset", n3);
                jSONBuffer.appendKeyValue("pagesize", n4);
                jSONBuffer.closeHash();
                if (LOG.isDebuggingFiner()) {
                    jSONBuffer.appendNewline();
                }
                OutlierScoreMeta outlierScoreMeta = outlierResult.getOutlierMeta();
                this.outlierMetaToJSON(jSONBuffer, outlierScoreMeta);
                jSONBuffer.appendKeyArray("scores");
                DoubleRelation doubleRelation = outlierResult.getScores();
                DBIDArrayMIter dBIDArrayMIter = outlierResult.getOrdering().order(doubleRelation.getDBIDs()).iter();
                for (n2 = 0; n2 < n3 && dBIDArrayMIter.valid(); ++n2) {
                    dBIDArrayMIter.advance();
                }
                for (n2 = 0; n2 < n4 && dBIDArrayMIter.valid(); ++n2) {
                    jSONBuffer.startHash();
                    this.bundleToJSON(jSONBuffer, dBIDArrayMIter);
                    double d = doubleRelation.doubleValue(dBIDArrayMIter);
                    if (!Double.isNaN(d)) {
                        jSONBuffer.appendKeyValue("score", d);
                    }
                    jSONBuffer.closeHash();
                    dBIDArrayMIter.advance();
                }
                jSONBuffer.closeArray();
                return;
            }
        }
        jSONBuffer.appendKeyValue("error", "unknown query");
    }

    private void outlierMetaToJSON(JSONBuffer jSONBuffer, OutlierScoreMeta outlierScoreMeta) {
        jSONBuffer.appendKeyHash("meta");
        jSONBuffer.appendKeyValue("min", outlierScoreMeta.getActualMinimum());
        jSONBuffer.appendKeyValue("max", outlierScoreMeta.getActualMaximum());
        jSONBuffer.appendKeyValue("tmin", outlierScoreMeta.getTheoreticalMinimum());
        jSONBuffer.appendKeyValue("tmax", outlierScoreMeta.getTheoreticalMaximum());
        jSONBuffer.appendKeyValue("base", outlierScoreMeta.getTheoreticalBaseline());
        jSONBuffer.appendKeyValue("type", outlierScoreMeta.getClass().getSimpleName());
        jSONBuffer.closeHash();
        if (LOG.isDebuggingFiner()) {
            jSONBuffer.appendNewline();
        }
    }

    @Override
    public void handle(HttpExchange httpExchange) throws IOException {
        Object object;
        String string = httpExchange.getRequestMethod();
        if (!string.equalsIgnoreCase("GET")) {
            return;
        }
        String string2 = httpExchange.getRequestURI().getPath();
        if (!string2.startsWith(PATH_JSON)) {
            LOG.warning("Unexpected path in request handler: " + string2);
            throw new AbortException("Unexpected path: " + string2);
        }
        string2 = string2.substring(PATH_JSON.length());
        String string3 = null;
        CharSequence charSequence = httpExchange.getRequestURI().getQuery();
        if (charSequence != null) {
            object = ((String)charSequence).split("&");
            for (String string4 : object) {
                if (string4.startsWith("jsonp=")) {
                    string3 = URLDecoder.decode(string4.substring("jsonp=".length()), "UTF-8");
                }
                if (!string4.startsWith("callback=")) continue;
                string3 = URLDecoder.decode(string4.substring("callback=".length()), "UTF-8");
            }
        }
        charSequence = new StringBuilder();
        if (string3 != null) {
            ((StringBuilder)charSequence).append(string3);
            ((StringBuilder)charSequence).append("(");
        }
        object = new JSONBuffer((StringBuilder)charSequence);
        try {
            object.startHash();
            this.resultToJSON((JSONBuffer)object, string2);
            object.closeHash();
        }
        catch (Throwable throwable) {
            LOG.exception("Exception occurred in embedded web server:", throwable);
            throw new IOException(throwable);
        }
        if (string3 != null) {
            ((StringBuilder)charSequence).append(")");
        }
        object = ((StringBuilder)charSequence).toString().getBytes("UTF-8");
        Headers headers = httpExchange.getResponseHeaders();
        headers.set("Content-Type", "text/javascript");
        httpExchange.sendResponseHeaders(200, ((String[])object).length);
        OutputStream outputStream = httpExchange.getResponseBody();
        outputStream.write((byte[])object);
        outputStream.close();
    }
}

