/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.distance.distancefunction.subspace;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.spatial.SpatialComparable;
import de.lmu.ifi.dbs.elki.data.type.VectorFieldTypeInformation;
import de.lmu.ifi.dbs.elki.data.type.VectorTypeInformation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.AbstractSpatialNorm;
import de.lmu.ifi.dbs.elki.distance.distancefunction.subspace.DimensionSelectingSubspaceDistanceFunction;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.BitsUtil;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;

@Alias(value={"de.lmu.ifi.dbs.elki.distance.distancefunction.subspace.DimensionSelectingDistanceFunction"})
public class OnedimensionalDistanceFunction
extends AbstractSpatialNorm
implements DimensionSelectingSubspaceDistanceFunction<NumberVector> {
    private int dim;

    public OnedimensionalDistanceFunction(int n) {
        this.dim = n;
    }

    @Override
    public double distance(NumberVector numberVector, NumberVector numberVector2) {
        if (this.dim >= numberVector.getDimensionality() || this.dim >= numberVector2.getDimensionality() || this.dim < 0) {
            throw new IllegalArgumentException("Specified dimension to be considered is larger that dimensionality of FeatureVectors:\n  first argument: " + numberVector.toString() + "\n  second argument: " + numberVector2.toString() + "\n  dimension: " + this.dim);
        }
        double d = numberVector.doubleValue(this.dim) - numberVector2.doubleValue(this.dim);
        return d >= 0.0 ? d : -d;
    }

    @Override
    public double minDist(SpatialComparable spatialComparable, SpatialComparable spatialComparable2) {
        double d;
        double d2;
        if (this.dim >= spatialComparable.getDimensionality() || this.dim >= spatialComparable2.getDimensionality() || this.dim < 0) {
            throw new IllegalArgumentException("Specified dimension to be considered is larger that dimensionality of FeatureVectors:\n  first argument: " + spatialComparable.toString() + "\n  second argument: " + spatialComparable2.toString() + "\n  dimension: " + this.dim);
        }
        double d3 = spatialComparable.getMax(this.dim);
        if (d3 < (d2 = spatialComparable2.getMin(this.dim))) {
            return d2 - d3;
        }
        double d4 = spatialComparable.getMin(this.dim);
        if (d4 > (d = spatialComparable2.getMax(this.dim))) {
            return d4 - d;
        }
        return 0.0;
    }

    @Override
    public double norm(NumberVector numberVector) {
        return Math.abs(numberVector.doubleValue(this.dim));
    }

    public int getSelectedDimension() {
        return this.dim;
    }

    @Override
    @Deprecated
    public long[] getSelectedDimensions() {
        long[] lArray = BitsUtil.zero(this.dim);
        BitsUtil.setI(lArray, this.dim);
        return lArray;
    }

    @Override
    @Deprecated
    public void setSelectedDimensions(long[] lArray) {
        this.dim = BitsUtil.nextSetBit(lArray, 0);
        if (this.dim == -1) {
            throw new IllegalStateException("No dimension was set.");
        }
        if (BitsUtil.nextSetBit(lArray, this.dim + 1) > 0) {
            throw new IllegalStateException("More than one dimension was set.");
        }
    }

    @Override
    public VectorTypeInformation<? super NumberVector> getInputTypeRestriction() {
        return VectorFieldTypeInformation.typeRequest(NumberVector.class, this.dim, Integer.MAX_VALUE);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!this.getClass().equals(object.getClass())) {
            return false;
        }
        return this.dim == ((OnedimensionalDistanceFunction)object).dim;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID DIM_ID = new OptionID("dim", "an integer between 1 and the dimensionality of the feature space 1 specifying the dimension to be considered for distance computation.");
        protected int dim = 0;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            super.makeOptions(parameterization);
            IntParameter intParameter = (IntParameter)new IntParameter(DIM_ID).addConstraint(CommonConstraints.GREATER_EQUAL_ZERO_INT);
            if (parameterization.grab(intParameter)) {
                this.dim = (Integer)intParameter.getValue();
            }
        }

        @Override
        protected OnedimensionalDistanceFunction makeInstance() {
            return new OnedimensionalDistanceFunction(this.dim);
        }
    }
}

