/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.evaluation.clustering;

import de.lmu.ifi.dbs.elki.evaluation.clustering.ClusterContingencyTable;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;

@Reference(authors="A. Bagga and B. Baldwin", title="Entity-based cross-document coreferencing using the Vector Space Model", booktitle="Proc. COLING '98 Proceedings of the 17th international conference on Computational linguistics", url="http://dx.doi.org/10.3115/980451.980859")
public class BCubed {
    protected double bCubedPrecision = 0.0;
    protected double bCubedRecall = 0.0;

    protected BCubed(ClusterContingencyTable clusterContingencyTable) {
        int n;
        for (n = 0; n < clusterContingencyTable.size1; ++n) {
            int[] nArray = clusterContingencyTable.contingency[n];
            for (int i = 0; i < clusterContingencyTable.size2; ++i) {
                int n2 = nArray[i];
                if (n2 <= 0) continue;
                double d = 1.0 * (double)n2 / (double)nArray[clusterContingencyTable.size2];
                this.bCubedPrecision += d * (double)n2;
                double d2 = 1.0 * (double)n2 / (double)clusterContingencyTable.contingency[clusterContingencyTable.size1][i];
                this.bCubedRecall += d2 * (double)n2;
            }
        }
        n = clusterContingencyTable.contingency[clusterContingencyTable.size1][clusterContingencyTable.size2];
        this.bCubedPrecision /= (double)n;
        this.bCubedRecall /= (double)n;
    }

    public double precision() {
        return this.bCubedPrecision;
    }

    public double recall() {
        return this.bCubedRecall;
    }

    public double f1Measure() {
        return ClusterContingencyTable.Util.f1Measure(this.precision(), this.recall());
    }
}

