/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.gui.configurator;

import de.lmu.ifi.dbs.elki.gui.configurator.ClassListParameterConfigurator;
import de.lmu.ifi.dbs.elki.gui.configurator.ClassParameterConfigurator;
import de.lmu.ifi.dbs.elki.gui.configurator.EnumParameterConfigurator;
import de.lmu.ifi.dbs.elki.gui.configurator.FileParameterConfigurator;
import de.lmu.ifi.dbs.elki.gui.configurator.FlagParameterConfigurator;
import de.lmu.ifi.dbs.elki.gui.configurator.ParameterConfigurator;
import de.lmu.ifi.dbs.elki.gui.configurator.TextParameterConfigurator;
import de.lmu.ifi.dbs.elki.logging.LoggingUtil;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.ListParameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.TrackParameters;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ClassListParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ClassParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.EnumParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.FileParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.Flag;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.Parameter;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.SoftBevelBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;

public class ConfiguratorPanel
extends JPanel
implements ChangeListener {
    private static final long serialVersionUID = 1L;
    private Map<Object, ParameterConfigurator> childconfig = new HashMap<Object, ParameterConfigurator>();
    private ArrayList<ParameterConfigurator> children = new ArrayList();
    protected EventListenerList listenerList = new EventListenerList();

    public ConfiguratorPanel() {
        super(new GridBagLayout());
    }

    public void addParameter(Object object, Parameter<?> parameter, TrackParameters trackParameters) {
        this.setBorder(new SoftBevelBorder(1));
        ParameterConfigurator parameterConfigurator = null;
        Object object2 = object;
        while (object2 != null && (parameterConfigurator = this.childconfig.get(object2)) == null) {
            object2 = trackParameters.getParent(object2);
        }
        if (parameterConfigurator != null) {
            parameterConfigurator.addParameter(object, parameter, trackParameters);
            return;
        }
        parameterConfigurator = this.makeConfigurator(parameter);
        parameterConfigurator.addChangeListener(this);
        this.children.add(parameterConfigurator);
    }

    private ParameterConfigurator makeConfigurator(Parameter<?> parameter) {
        if (parameter instanceof Flag) {
            return new FlagParameterConfigurator((Flag)parameter, (JComponent)this);
        }
        if (parameter instanceof ClassListParameter) {
            ClassListParameterConfigurator classListParameterConfigurator = new ClassListParameterConfigurator((ClassListParameter)parameter, (JComponent)this);
            this.childconfig.put(parameter, classListParameterConfigurator);
            return classListParameterConfigurator;
        }
        if (parameter instanceof ClassParameter) {
            ClassParameterConfigurator classParameterConfigurator = new ClassParameterConfigurator((ClassParameter)parameter, (JComponent)this);
            this.childconfig.put(parameter, classParameterConfigurator);
            return classParameterConfigurator;
        }
        if (parameter instanceof FileParameter) {
            return new FileParameterConfigurator((FileParameter)parameter, (JComponent)this);
        }
        if (parameter instanceof EnumParameter) {
            return new EnumParameterConfigurator((EnumParameter)parameter, (JComponent)this);
        }
        return new TextParameterConfigurator(parameter, (JComponent)this);
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        if (changeEvent.getSource() instanceof ParameterConfigurator) {
            this.fireValueChanged();
        } else {
            LoggingUtil.warning("stateChanged triggered by unknown source: " + changeEvent.getSource());
        }
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listenerList.add(ChangeListener.class, changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listenerList.remove(ChangeListener.class, changeListener);
    }

    protected void fireValueChanged() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        for (ChangeListener changeListener : (ChangeListener[])this.listenerList.getListeners(ChangeListener.class)) {
            changeListener.stateChanged(changeEvent);
        }
    }

    public void appendParameters(ListParameterization listParameterization) {
        for (ParameterConfigurator parameterConfigurator : this.children) {
            parameterConfigurator.appendParameters(listParameterization);
        }
    }

    public void clear() {
        this.removeAll();
        this.childconfig.clear();
        this.children.clear();
    }
}

