/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants;

import de.lmu.ifi.dbs.elki.database.ids.DBID;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.index.tree.AbstractNode;
import de.lmu.ifi.dbs.elki.index.tree.BreadthFirstEnumeration;
import de.lmu.ifi.dbs.elki.index.tree.Entry;
import de.lmu.ifi.dbs.elki.index.tree.IndexTreePath;
import de.lmu.ifi.dbs.elki.index.tree.metrical.MetricalIndexTree;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.AbstractMTreeNode;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.MTreeEntry;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.MTreeSettings;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.strategies.split.Assignments;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.strategies.split.DistanceEntry;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.statistics.Counter;
import de.lmu.ifi.dbs.elki.logging.statistics.LongStatistic;
import de.lmu.ifi.dbs.elki.persistent.AbstractExternalizablePage;
import de.lmu.ifi.dbs.elki.persistent.PageFile;
import de.lmu.ifi.dbs.elki.utilities.pairs.DoubleIntPair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class AbstractMTree<O, N extends AbstractMTreeNode<O, N, E>, E extends MTreeEntry, S extends MTreeSettings<O, N, E>>
extends MetricalIndexTree<O, N, E> {
    protected static final boolean EXTRA_INTEGRITY_CHECKS = false;
    protected S settings;
    public Statistics statistics = new Statistics();

    public AbstractMTree(PageFile<N> pageFile, S s) {
        super(pageFile);
        this.settings = s;
    }

    @Override
    public final DistanceFunction<? super O> getDistanceFunction() {
        return ((MTreeSettings)this.settings).distanceFunction;
    }

    public String toString() {
        Object object;
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        AbstractMTreeNode abstractMTreeNode = (AbstractMTreeNode)this.getRoot();
        while (!abstractMTreeNode.isLeaf()) {
            if (abstractMTreeNode.getNumEntries() <= 0) continue;
            object = (MTreeEntry)abstractMTreeNode.getEntry(0);
            abstractMTreeNode = (AbstractMTreeNode)this.getNode(object);
            ++n4;
        }
        object = new BreadthFirstEnumeration(this, this.getRootPath());
        while (((BreadthFirstEnumeration)object).hasMoreElements()) {
            Object object2 = ((BreadthFirstEnumeration)object).nextElement();
            MTreeEntry mTreeEntry = (MTreeEntry)((IndexTreePath)object2).getEntry();
            if (mTreeEntry.isLeafEntry()) {
                ++n3;
                stringBuilder.append("\n    ").append(mTreeEntry.toString());
                continue;
            }
            abstractMTreeNode = (AbstractMTreeNode)this.getNode(mTreeEntry);
            stringBuilder.append("\n\n").append(abstractMTreeNode).append(", numEntries = ").append(abstractMTreeNode.getNumEntries());
            stringBuilder.append("\n").append(mTreeEntry.toString());
            if (abstractMTreeNode.isLeaf()) {
                ++n2;
                continue;
            }
            ++n;
        }
        stringBuilder.append(this.getClass().getName()).append(" hat ").append(n4 + 1).append(" Ebenen \n");
        stringBuilder.append("DirCapacity = ").append(this.dirCapacity).append("\n");
        stringBuilder.append("LeafCapacity = ").append(this.leafCapacity).append("\n");
        stringBuilder.append(n).append(" Directory Nodes \n");
        stringBuilder.append(n2).append(" Leaf Nodes \n");
        stringBuilder.append(n3).append(" Objects \n");
        return stringBuilder.toString();
    }

    public void insert(E e, boolean bl) {
        if (this.getLogger().isDebugging()) {
            this.getLogger().debugFine("insert " + e.getRoutingObjectID() + "\n");
        }
        if (!this.initialized) {
            this.initialize(e);
        }
        IndexTreePath indexTreePath = ((MTreeSettings)this.settings).insertStrategy.choosePath(this, e);
        if (this.getLogger().isDebugging()) {
            this.getLogger().debugFine("insertion-subtree " + indexTreePath + "\n");
        }
        MTreeEntry mTreeEntry = (MTreeEntry)indexTreePath.getEntry();
        double d = this.distance(mTreeEntry.getRoutingObjectID(), e.getRoutingObjectID());
        e.setParentDistance(d);
        if (bl) {
            this.preInsert(e);
        }
        AbstractMTreeNode abstractMTreeNode = (AbstractMTreeNode)this.getNode(mTreeEntry);
        abstractMTreeNode.addLeafEntry(e);
        this.writeNode(abstractMTreeNode);
        this.adjustTree(indexTreePath);
    }

    public void insertAll(List<E> list) {
        if (!this.initialized && list.size() > 0) {
            this.initialize((Entry)list.get(0));
        }
        for (MTreeEntry mTreeEntry : list) {
            this.insert(mTreeEntry, false);
        }
    }

    @Override
    protected final void createEmptyRoot(E e) {
        AbstractMTreeNode abstractMTreeNode = (AbstractMTreeNode)this.createNewLeafNode();
        this.writeNode(abstractMTreeNode);
    }

    protected final List<DoubleIntPair> getSortedEntries(N n, DBID dBID) {
        ArrayList<DoubleIntPair> arrayList = new ArrayList<DoubleIntPair>();
        for (int i = 0; i < ((AbstractNode)n).getNumEntries(); ++i) {
            MTreeEntry mTreeEntry = (MTreeEntry)((AbstractNode)n).getEntry(i);
            double d = this.distance(mTreeEntry.getRoutingObjectID(), dBID);
            double d2 = mTreeEntry.getCoveringRadius();
            double d3 = d2 > d ? 0.0 : d - d2;
            arrayList.add(new DoubleIntPair(d3, i));
        }
        Collections.sort(arrayList);
        return arrayList;
    }

    public abstract double distance(DBIDRef var1, DBIDRef var2);

    public final double distance(E e, E e2) {
        return this.distance(e.getRoutingObjectID(), e2.getRoutingObjectID());
    }

    protected abstract E createNewDirectoryEntry(N var1, DBID var2, double var3);

    private void adjustTree(IndexTreePath<E> indexTreePath) {
        if (this.getLogger().isDebugging()) {
            this.getLogger().debugFine("Adjust tree " + indexTreePath + "\n");
        }
        int n = indexTreePath.getIndex();
        AbstractMTreeNode abstractMTreeNode = (AbstractMTreeNode)this.getNode(indexTreePath.getEntry());
        if (this.hasOverflow(abstractMTreeNode)) {
            Object object;
            MTreeEntry mTreeEntry;
            Assignments assignments = ((MTreeSettings)this.settings).splitStrategy.split(this, abstractMTreeNode);
            AbstractMTreeNode abstractMTreeNode2 = abstractMTreeNode.isLeaf() ? (AbstractMTreeNode)this.createNewLeafNode() : (AbstractMTreeNode)this.createNewDirectoryNode();
            ArrayList<MTreeEntry> arrayList = new ArrayList<MTreeEntry>(assignments.getFirstAssignments().size());
            ArrayList<MTreeEntry> arrayList2 = new ArrayList<MTreeEntry>(assignments.getSecondAssignments().size());
            for (DistanceEntry object2 : assignments.getFirstAssignments()) {
                mTreeEntry = (MTreeEntry)object2.getEntry();
                mTreeEntry.setParentDistance(object2.getDistance());
                arrayList.add(mTreeEntry);
            }
            for (DistanceEntry distanceEntry : assignments.getSecondAssignments()) {
                mTreeEntry = (MTreeEntry)distanceEntry.getEntry();
                mTreeEntry.setParentDistance(distanceEntry.getDistance());
                arrayList2.add(mTreeEntry);
            }
            abstractMTreeNode.splitTo(abstractMTreeNode2, arrayList, arrayList2);
            this.writeNode(abstractMTreeNode);
            this.writeNode(abstractMTreeNode2);
            if (this.getLogger().isDebuggingFine()) {
                object = "Split Node " + abstractMTreeNode.getPageID() + " (" + this.getClass() + ")\n" + "      newNode " + abstractMTreeNode2.getPageID() + "\n" + "      firstPromoted " + assignments.getFirstRoutingObject() + "\n" + "      firstAssignments(" + abstractMTreeNode.getPageID() + ") " + assignments.getFirstAssignments() + "\n" + "      firstCR " + assignments.computeFirstCover(abstractMTreeNode.isLeaf()) + "\n" + "      secondPromoted " + assignments.getSecondRoutingObject() + "\n" + "      secondAssignments(" + abstractMTreeNode2.getPageID() + ") " + assignments.getSecondAssignments() + "\n" + "      secondCR " + assignments.computeSecondCover(abstractMTreeNode.isLeaf()) + "\n";
                this.getLogger().debugFine((CharSequence)object);
            }
            if (this.isRoot(abstractMTreeNode)) {
                object = this.createNewRoot(abstractMTreeNode, abstractMTreeNode2, assignments.getFirstRoutingObject(), assignments.getSecondRoutingObject());
                this.adjustTree((IndexTreePath<E>)object);
            } else {
                object = (MTreeEntry)indexTreePath.getParentPath().getEntry();
                AbstractMTreeNode abstractMTreeNode3 = (AbstractMTreeNode)this.getNode(object);
                if (this.getLogger().isDebugging()) {
                    this.getLogger().debugFine("parent " + abstractMTreeNode3);
                }
                double d = this.distance(object.getRoutingObjectID(), assignments.getSecondRoutingObject());
                abstractMTreeNode3.addDirectoryEntry(this.createNewDirectoryEntry(abstractMTreeNode2, assignments.getSecondRoutingObject(), d));
                double d2 = this.distance(object.getRoutingObjectID(), assignments.getFirstRoutingObject());
                abstractMTreeNode.adjustEntry((MTreeEntry)abstractMTreeNode3.getEntry(n), assignments.getFirstRoutingObject(), d2, this);
                this.writeNode(abstractMTreeNode3);
                this.adjustTree(indexTreePath.getParentPath());
            }
        } else if (!this.isRoot(abstractMTreeNode)) {
            int n2;
            MTreeEntry mTreeEntry = (MTreeEntry)indexTreePath.getParentPath().getEntry();
            AbstractMTreeNode abstractMTreeNode3 = (AbstractMTreeNode)this.getNode(mTreeEntry);
            MTreeEntry mTreeEntry2 = (MTreeEntry)abstractMTreeNode3.getEntry(n2 = indexTreePath.getIndex());
            boolean bl = abstractMTreeNode.adjustEntry(mTreeEntry2, mTreeEntry2.getRoutingObjectID(), mTreeEntry2.getParentDistance(), this);
            if (bl) {
                this.writeNode(abstractMTreeNode3);
                this.adjustTree(indexTreePath.getParentPath());
            }
        } else {
            MTreeEntry mTreeEntry = (MTreeEntry)this.getRootEntry();
            abstractMTreeNode.adjustEntry(mTreeEntry, mTreeEntry.getRoutingObjectID(), mTreeEntry.getParentDistance(), this);
        }
    }

    private boolean hasOverflow(N n) {
        if (((AbstractNode)n).isLeaf()) {
            return ((AbstractNode)n).getNumEntries() == this.leafCapacity;
        }
        return ((AbstractNode)n).getNumEntries() == this.dirCapacity;
    }

    private IndexTreePath<E> createNewRoot(N n, N n2, DBID dBID, DBID dBID2) {
        AbstractMTreeNode abstractMTreeNode;
        AbstractMTreeNode abstractMTreeNode2 = (AbstractMTreeNode)this.createNewDirectoryNode();
        this.writeNode(abstractMTreeNode2);
        ((AbstractExternalizablePage)n).setPageID(abstractMTreeNode2.getPageID());
        if (!((AbstractNode)n).isLeaf()) {
            for (int i = 0; i < ((AbstractNode)n).getNumEntries(); ++i) {
                abstractMTreeNode = (AbstractMTreeNode)this.getNode(((AbstractNode)n).getEntry(i));
                this.writeNode(abstractMTreeNode);
            }
        }
        abstractMTreeNode2.setPageID(this.getRootID());
        E e = this.createNewDirectoryEntry(n, dBID, 0.0);
        abstractMTreeNode = this.createNewDirectoryEntry(n2, dBID2, 0.0);
        abstractMTreeNode2.addDirectoryEntry(e);
        abstractMTreeNode2.addDirectoryEntry(abstractMTreeNode);
        this.writeNode(abstractMTreeNode2);
        this.writeNode(n);
        this.writeNode(n2);
        if (this.getLogger().isDebugging()) {
            String string = "Create new Root: ID=" + abstractMTreeNode2.getPageID();
            string = string + "\nchild1 " + n;
            string = string + "\nchild2 " + n2;
            this.getLogger().debugFine(string);
        }
        return new IndexTreePath(null, this.getRootEntry(), -1);
    }

    @Override
    public List<E> getLeaves() {
        ArrayList<MTreeEntry> arrayList = new ArrayList<MTreeEntry>();
        BreadthFirstEnumeration breadthFirstEnumeration = new BreadthFirstEnumeration(this, this.getRootPath());
        while (breadthFirstEnumeration.hasMoreElements()) {
            AbstractMTreeNode abstractMTreeNode;
            Object object = breadthFirstEnumeration.nextElement();
            MTreeEntry mTreeEntry = (MTreeEntry)((IndexTreePath)object).getEntry();
            if (mTreeEntry.isLeafEntry() || !(abstractMTreeNode = (AbstractMTreeNode)this.getNode(mTreeEntry)).isLeaf()) continue;
            arrayList.add(mTreeEntry);
        }
        return arrayList;
    }

    public int getHeight() {
        int n = 0;
        AbstractMTreeNode abstractMTreeNode = (AbstractMTreeNode)this.getRoot();
        while (!abstractMTreeNode.isLeaf()) {
            if (abstractMTreeNode.getNumEntries() <= 0) continue;
            MTreeEntry mTreeEntry = (MTreeEntry)abstractMTreeNode.getEntry(0);
            abstractMTreeNode = (AbstractMTreeNode)this.getNode(mTreeEntry);
            ++n;
        }
        return n;
    }

    @Override
    public void logStatistics() {
        super.logStatistics();
        Logging logging = this.getLogger();
        if (logging.isStatistics()) {
            logging.statistics(new LongStatistic(this.getClass().getName() + ".height", this.getHeight()));
            this.statistics.logStatistics();
        }
    }

    public class Statistics {
        protected final Counter distanceCalcs;
        protected final Counter knnQueries;
        protected final Counter rangeQueries;

        public Statistics() {
            Logging logging = AbstractMTree.this.getLogger();
            this.distanceCalcs = logging.isStatistics() ? logging.newCounter(this.getClass().getName() + ".distancecalcs") : null;
            this.knnQueries = logging.isStatistics() ? logging.newCounter(this.getClass().getName() + ".knnqueries") : null;
            this.rangeQueries = logging.isStatistics() ? logging.newCounter(this.getClass().getName() + ".rangequeries") : null;
        }

        public void countDistanceCalculation() {
            if (this.distanceCalcs != null) {
                this.distanceCalcs.increment();
            }
        }

        public void countKNNQuery() {
            if (this.knnQueries != null) {
                this.knnQueries.increment();
            }
        }

        public void countRangeQuery() {
            if (this.rangeQueries != null) {
                this.rangeQueries.increment();
            }
        }

        public void logStatistics() {
            Logging logging = AbstractMTree.this.getLogger();
            if (AbstractMTree.this.statistics.distanceCalcs != null) {
                logging.statistics(AbstractMTree.this.statistics.distanceCalcs);
            }
            if (AbstractMTree.this.statistics.knnQueries != null) {
                logging.statistics(AbstractMTree.this.statistics.knnQueries);
            }
            if (AbstractMTree.this.statistics.rangeQueries != null) {
                logging.statistics(AbstractMTree.this.statistics.rangeQueries);
            }
        }
    }
}

