/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math;

import de.lmu.ifi.dbs.elki.math.DoubleMinMax;
import de.lmu.ifi.dbs.elki.math.Mean;
import de.lmu.ifi.dbs.elki.math.MeanVariance;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;

public class MeanVarianceMinMax
extends MeanVariance {
    double min = Double.POSITIVE_INFINITY;
    double max = Double.NEGATIVE_INFINITY;

    public MeanVarianceMinMax() {
    }

    public MeanVarianceMinMax(MeanVarianceMinMax meanVarianceMinMax) {
        super(meanVarianceMinMax);
        this.min = meanVarianceMinMax.min;
        this.max = meanVarianceMinMax.max;
    }

    @Override
    public void put(double d) {
        super.put(d);
        this.min = d < this.min ? d : this.min;
        this.max = d > this.max ? d : this.max;
    }

    @Override
    public void put(double d, double d2) {
        super.put(d, d2);
        this.min = d < this.min ? d : this.min;
        this.max = d > this.max ? d : this.max;
    }

    @Override
    public void put(Mean mean) {
        if (!(mean instanceof MeanVarianceMinMax)) {
            throw new AbortException("Cannot aggregate into a minmax statistic: " + mean.getClass());
        }
        super.put(mean);
        this.min = Math.min(this.min, ((MeanVarianceMinMax)mean).min);
        this.max = Math.max(this.max, ((MeanVarianceMinMax)mean).max);
    }

    @Override
    public MeanVarianceMinMax put(double[] dArray) {
        double d;
        double d2;
        if (dArray.length <= 2) {
            int n = dArray.length;
            int n2 = 0;
            while (n2 < n) {
                this.put(dArray[n]);
            }
            return this;
        }
        double d3 = 0.0;
        int n = dArray.length;
        int n3 = 0;
        while (n3 < n) {
            d2 = dArray[n];
            d3 += d2;
            this.min = d2 < this.min ? d2 : this.min;
            this.max = d2 > this.max ? d2 : this.max;
        }
        d2 = d3 / (double)dArray.length;
        double d4 = 0.0;
        n3 = 0;
        while (n3 < n) {
            d = dArray[n] - d2;
            d4 += d * d;
        }
        d = (double)dArray.length + this.n;
        double d5 = d2 - this.m1;
        double d6 = d5 * (double)dArray.length / d;
        this.m1 = (this.n * this.m1 + d3) / d;
        this.m2 += d4 + d5 * this.n * d6;
        this.n = d;
        return this;
    }

    @Override
    public MeanVarianceMinMax put(double[] dArray, double[] dArray2) {
        assert (dArray.length == dArray2.length);
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            this.put(dArray[i], dArray2[i]);
        }
        return this;
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }

    public DoubleMinMax getDoubleMinMax() {
        return new DoubleMinMax(this.min, this.max);
    }

    public double getDiff() {
        return this.getMax() - this.getMin();
    }

    public static MeanVarianceMinMax[] newArray(int n) {
        MeanVarianceMinMax[] meanVarianceMinMaxArray = new MeanVarianceMinMax[n];
        for (int i = 0; i < n; ++i) {
            meanVarianceMinMaxArray[i] = new MeanVarianceMinMax();
        }
        return meanVarianceMinMaxArray;
    }

    @Override
    public String toString() {
        return "MeanVarianceMinMax(mean=" + this.getMean() + ",var=" + this.getSampleVariance() + ",min=" + this.getMin() + ",max=" + this.getMax() + ")";
    }

    @Override
    public void reset() {
        super.reset();
        this.min = Double.POSITIVE_INFINITY;
        this.max = Double.NEGATIVE_INFINITY;
    }
}

