/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.distribution;

import de.lmu.ifi.dbs.elki.math.random.RandomFactory;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.AbstractDistribution;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.GammaDistribution;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import java.util.Random;

public class LogGammaAlternateDistribution
extends AbstractDistribution {
    private final double k;
    private final double theta;
    private final double shift;

    public LogGammaAlternateDistribution(double d, double d2, double d3, Random random) {
        super(random);
        if (!(d > 0.0) || !(d2 > 0.0)) {
            throw new IllegalArgumentException("Invalid parameters for Gamma distribution: " + d + " " + d2);
        }
        this.k = d;
        this.theta = d2;
        this.shift = d3;
    }

    public LogGammaAlternateDistribution(double d, double d2, double d3, RandomFactory randomFactory) {
        super(randomFactory);
        if (!(d > 0.0) || !(d2 > 0.0)) {
            throw new IllegalArgumentException("Invalid parameters for Gamma distribution: " + d + " " + d2);
        }
        this.k = d;
        this.theta = d2;
        this.shift = d3;
    }

    public LogGammaAlternateDistribution(double d, double d2, double d3) {
        this(d, d2, d3, (Random)null);
    }

    @Override
    public double pdf(double d) {
        return LogGammaAlternateDistribution.pdf(d, this.k, this.theta, this.shift);
    }

    @Override
    public double cdf(double d) {
        return LogGammaAlternateDistribution.cdf(d, this.k, this.theta, this.shift);
    }

    @Override
    public double quantile(double d) {
        return LogGammaAlternateDistribution.quantile(d, this.k, this.theta, this.shift);
    }

    @Override
    public double nextRandom() {
        return Math.log(GammaDistribution.nextRandom(this.k, 1.0, this.random)) / this.theta + this.shift;
    }

    @Override
    public String toString() {
        return "LogGammaAlternateDistribution(k=" + this.k + ", theta=" + this.theta + ", shift=" + this.shift + ")";
    }

    public double getK() {
        return this.k;
    }

    public double getTheta() {
        return this.theta;
    }

    public static double cdf(double d, double d2, double d3, double d4) {
        if (d <= d4) {
            return 0.0;
        }
        d = (d - d4) * d3;
        return GammaDistribution.regularizedGammaP(d2, Math.exp(d));
    }

    public static double logcdf(double d, double d2, double d3, double d4) {
        if (d <= d4) {
            return 0.0;
        }
        d = (d - d4) * d3;
        return GammaDistribution.logregularizedGammaP(d2, Math.exp(d));
    }

    public static double pdf(double d, double d2, double d3, double d4) {
        if (d <= d4) {
            return 0.0;
        }
        d = (d - d4) * d3;
        return d3 * Math.exp(d2 * d - Math.exp(d) - GammaDistribution.logGamma(d2));
    }

    public static double logpdf(double d, double d2, double d3, double d4) {
        if (d <= d4) {
            return 0.0;
        }
        d = (d - d4) * d3;
        return Math.log(d3) + d2 * d - Math.exp(d) - GammaDistribution.logGamma(d2);
    }

    public static double quantile(double d, double d2, double d3, double d4) {
        return Math.log(GammaDistribution.quantile(d, d2, 1.0)) / d3 + d4;
    }

    public static class Parameterizer
    extends AbstractDistribution.Parameterizer {
        public static final OptionID SHIFT_ID = new OptionID("distribution.loggamma.shift", "Shift offset parameter.");
        double k;
        double theta;
        double shift;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            DoubleParameter doubleParameter;
            DoubleParameter doubleParameter2;
            super.makeOptions(parameterization);
            DoubleParameter doubleParameter3 = new DoubleParameter(GammaDistribution.Parameterizer.K_ID);
            if (parameterization.grab(doubleParameter3)) {
                this.k = doubleParameter3.doubleValue();
            }
            if (parameterization.grab(doubleParameter2 = new DoubleParameter(GammaDistribution.Parameterizer.THETA_ID))) {
                this.theta = doubleParameter2.doubleValue();
            }
            if (parameterization.grab(doubleParameter = new DoubleParameter(SHIFT_ID))) {
                this.shift = doubleParameter.doubleValue();
            }
        }

        @Override
        protected LogGammaAlternateDistribution makeInstance() {
            return new LogGammaAlternateDistribution(this.k, this.theta, this.shift, this.rnd);
        }
    }
}

