/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.distribution;

import de.lmu.ifi.dbs.elki.math.random.RandomFactory;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.AbstractDistribution;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import java.util.Random;

public class RayleighDistribution
extends AbstractDistribution {
    double mu = 0.0;
    double sigma;

    public RayleighDistribution(double d) {
        this(0.0, d, (Random)null);
    }

    public RayleighDistribution(double d, double d2) {
        this(d, d2, (Random)null);
    }

    public RayleighDistribution(double d, Random random) {
        this(0.0, d, random);
    }

    public RayleighDistribution(double d, double d2, Random random) {
        super(random);
        this.mu = d;
        this.sigma = d2;
    }

    public RayleighDistribution(double d, double d2, RandomFactory randomFactory) {
        super(randomFactory);
        this.mu = d;
        this.sigma = d2;
    }

    @Override
    public double pdf(double d) {
        return RayleighDistribution.pdf(d - this.mu, this.sigma);
    }

    public static double pdf(double d, double d2) {
        if (d <= 0.0) {
            return 0.0;
        }
        double d3 = d / d2;
        return d3 / d2 * Math.exp(-0.5 * d3 * d3);
    }

    @Override
    public double cdf(double d) {
        return RayleighDistribution.cdf(d - this.mu, this.sigma);
    }

    public static double cdf(double d, double d2) {
        if (d <= 0.0) {
            return 0.0;
        }
        double d3 = d / d2;
        return 1.0 - Math.exp(-0.5 * d3 * d3);
    }

    @Override
    public double quantile(double d) {
        return this.mu + RayleighDistribution.quantile(d, this.sigma);
    }

    public static double quantile(double d, double d2) {
        if (!(d >= 0.0) || !(d <= 1.0)) {
            return Double.NaN;
        }
        if (d == 0.0) {
            return 0.0;
        }
        if (d == 1.0) {
            return Double.POSITIVE_INFINITY;
        }
        return d2 * Math.sqrt(-2.0 * Math.log(d));
    }

    @Override
    public double nextRandom() {
        return this.mu + this.sigma * Math.sqrt(-2.0 * Math.log(this.random.nextDouble()));
    }

    @Override
    public String toString() {
        return "RayleighDistribution(mu=" + this.mu + ", sigma=" + this.sigma + ")";
    }

    public static class Parameterizer
    extends AbstractDistribution.Parameterizer {
        double mean;
        double scale;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            DoubleParameter doubleParameter;
            super.makeOptions(parameterization);
            DoubleParameter doubleParameter2 = new DoubleParameter(LOCATION_ID, 0.0);
            if (parameterization.grab(doubleParameter2)) {
                this.mean = doubleParameter2.doubleValue();
            }
            if (parameterization.grab(doubleParameter = new DoubleParameter(SCALE_ID))) {
                this.scale = doubleParameter.doubleValue();
            }
        }

        @Override
        protected RayleighDistribution makeInstance() {
            return new RayleighDistribution(this.mean, this.scale, this.rnd);
        }
    }
}

