/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator;

import de.lmu.ifi.dbs.elki.math.statistics.distribution.GammaDistribution;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.AbstractMADEstimator;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;

@Reference(authors="J. Chen. H. Rubin", title="Bounds for the difference between median and mean of Gamma and Poisson distributions", booktitle="Statist. Probab. Lett., 4")
public class GammaMADEstimator
extends AbstractMADEstimator<GammaDistribution> {
    public static final GammaMADEstimator STATIC = new GammaMADEstimator();

    private GammaMADEstimator() {
    }

    @Override
    public GammaDistribution estimateFromMedianMAD(double d, double d2) {
        if (d < Double.MIN_NORMAL) {
            throw new ArithmeticException("Cannot estimate Gamma parameters on a distribution with zero median.");
        }
        if (d2 < Double.MIN_NORMAL) {
            throw new ArithmeticException("Cannot estimate Gamma parameters on a distribution with zero MAD.");
        }
        double d3 = d / (d2 * d2);
        double d4 = d * d3;
        if (!(d4 > 0.0) || !(d3 > 0.0)) {
            throw new ArithmeticException("Gamma estimation produced non-positive parameter values: k=" + d4 + " theta=" + d3);
        }
        return new GammaDistribution(d4, d3);
    }

    @Override
    public Class<? super GammaDistribution> getDistributionClass() {
        return GammaDistribution.class;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected GammaMADEstimator makeInstance() {
            return STATIC;
        }
    }
}

