/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator;

import de.lmu.ifi.dbs.elki.math.statistics.distribution.LogGammaAlternateDistribution;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.AbstractExpMADEstimator;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;

public class LogGammaAlternateExpMADEstimator
extends AbstractExpMADEstimator<LogGammaAlternateDistribution> {
    public static final LogGammaAlternateExpMADEstimator STATIC = new LogGammaAlternateExpMADEstimator();

    private LogGammaAlternateExpMADEstimator() {
    }

    @Override
    public LogGammaAlternateDistribution estimateFromExpMedianMAD(double d, double d2) {
        if (d < Double.MIN_NORMAL) {
            throw new ArithmeticException("Cannot estimate Gamma parameters on a distribution with zero median.");
        }
        if (d2 < Double.MIN_NORMAL) {
            throw new ArithmeticException("Cannot estimate Gamma parameters on a distribution with zero MAD.");
        }
        double d3 = d / (d2 * d2);
        double d4 = d * d3;
        if (!(d4 > 0.0) || !(d3 > 0.0)) {
            throw new ArithmeticException("LogGammaAlternate estimation produced non-positive parameter values: k=" + d4 + " b=" + d3 + " median=" + d + " mad=" + d2);
        }
        return new LogGammaAlternateDistribution(d4, Math.log(d3), 0.0);
    }

    @Override
    public Class<? super LogGammaAlternateDistribution> getDistributionClass() {
        return LogGammaAlternateDistribution.class;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected LogGammaAlternateExpMADEstimator makeInstance() {
            return STATIC;
        }
    }
}

