/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.style.lines;

import de.lmu.ifi.dbs.elki.visualization.colors.ColorLibrary;
import de.lmu.ifi.dbs.elki.visualization.css.CSSClass;
import de.lmu.ifi.dbs.elki.visualization.style.StyleLibrary;
import de.lmu.ifi.dbs.elki.visualization.style.lines.LineStyleLibrary;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGUtil;

public class DashedLineStyleLibrary
implements LineStyleLibrary {
    private ColorLibrary colors;
    private double[][] dashpatterns = new double[][]{new double[0], {0.5, 0.5}, {0.25, 0.25, 0.25, 0.25}, {0.75, 0.25}, {0.7, 0.1, 0.1, 0.1}};
    private double[] solidreplacement = new double[]{0.1, 0.1};
    private int dashnum = this.dashpatterns.length;
    private String dotcolor;
    private String greycolor;

    public DashedLineStyleLibrary(StyleLibrary styleLibrary) {
        this.colors = styleLibrary.getColorSet("plot");
        this.dotcolor = styleLibrary.getColor("plot.marker");
        this.greycolor = styleLibrary.getColor("plot.grey");
    }

    @Override
    public void formatCSSClass(CSSClass cSSClass, int n, double d, Object ... objectArray) {
        int n2;
        if (n == -2) {
            cSSClass.setStatement("stroke", this.greycolor);
        } else if (n == -1) {
            cSSClass.setStatement("stroke", this.dotcolor);
        } else {
            cSSClass.setStatement("stroke", this.colors.getColor(n));
        }
        boolean bl = false;
        for (Object object : objectArray) {
            if ("strong".equals(object)) {
                d *= 1.5;
                continue;
            }
            if ("weak".equals(object)) {
                cSSClass.setStatement("stroke-opacity", ".50");
                d *= 0.75;
                continue;
            }
            if (!"interpolated".equals(object)) continue;
            bl = true;
        }
        cSSClass.setStatement("stroke-width", SVGUtil.fmt(d));
        int n3 = n2 = n > 0 ? n % this.dashnum : -n % this.dashnum;
        if (!bl) {
            double[] dArray = this.dashpatterns[n2];
            assert (dArray.length % 2 == 0);
            if (dArray.length > 0) {
                StringBuilder stringBuilder = new StringBuilder();
                for (int i = 0; i < dArray.length; ++i) {
                    if (i > 0) {
                        stringBuilder.append(',');
                    }
                    stringBuilder.append(SVGUtil.fmt(dArray[i] * d * 30.0));
                }
                cSSClass.setStatement("stroke-dasharray", stringBuilder.toString());
            }
        } else {
            double[] dArray = this.dashpatterns[n2];
            if (n2 == 0) {
                dArray = this.solidreplacement;
            }
            assert (dArray.length % 2 == 0);
            if (dArray.length > 0) {
                StringBuilder stringBuilder = new StringBuilder();
                for (int i = 0; i < dArray.length; ++i) {
                    if (i > 0) {
                        stringBuilder.append(',');
                    }
                    stringBuilder.append(SVGUtil.fmt(dArray[i] * d));
                }
                cSSClass.setStatement("stroke-dasharray", stringBuilder.toString());
            }
        }
    }
}

