/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.visualizers.scatterplot.selection;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.VectorUtil;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreListener;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.KNNList;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.ArcCosineDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.CosineDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski.LPNormDistanceFunction;
import de.lmu.ifi.dbs.elki.index.preprocessed.knn.AbstractMaterializeKNNPreprocessor;
import de.lmu.ifi.dbs.elki.logging.LoggingUtil;
import de.lmu.ifi.dbs.elki.math.MathUtil;
import de.lmu.ifi.dbs.elki.math.linearalgebra.VMath;
import de.lmu.ifi.dbs.elki.result.DBIDSelection;
import de.lmu.ifi.dbs.elki.utilities.exceptions.ObjectNotFoundException;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTask;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTree;
import de.lmu.ifi.dbs.elki.visualization.VisualizerContext;
import de.lmu.ifi.dbs.elki.visualization.css.CSSClass;
import de.lmu.ifi.dbs.elki.visualization.gui.VisualizationPlot;
import de.lmu.ifi.dbs.elki.visualization.projections.CanvasSize;
import de.lmu.ifi.dbs.elki.visualization.projections.Projection;
import de.lmu.ifi.dbs.elki.visualization.projections.Projection2D;
import de.lmu.ifi.dbs.elki.visualization.projector.ScatterPlotProjector;
import de.lmu.ifi.dbs.elki.visualization.style.StyleLibrary;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGHyperSphere;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGPath;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGPlot;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGUtil;
import de.lmu.ifi.dbs.elki.visualization.visualizers.AbstractVisFactory;
import de.lmu.ifi.dbs.elki.visualization.visualizers.Visualization;
import de.lmu.ifi.dbs.elki.visualization.visualizers.scatterplot.AbstractScatterplotVisualization;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DistanceFunctionVisualization
extends AbstractVisFactory {
    public static final String NAME = "k Nearest Neighbor Visualization";

    @Override
    public Visualization makeVisualization(VisualizationTask visualizationTask, VisualizationPlot visualizationPlot, double d, double d2, Projection projection) {
        return new Instance(visualizationTask, visualizationPlot, d, d2, projection);
    }

    @Override
    public void processNewResult(VisualizerContext visualizerContext, Object object) {
        VisualizationTree.findNewSiblings(visualizerContext, object, AbstractMaterializeKNNPreprocessor.class, ScatterPlotProjector.class, new VisualizationTree.Handler2<AbstractMaterializeKNNPreprocessor<?>, ScatterPlotProjector<?>>(){

            @Override
            public void process(VisualizerContext visualizerContext, AbstractMaterializeKNNPreprocessor<?> abstractMaterializeKNNPreprocessor, ScatterPlotProjector<?> scatterPlotProjector) {
                Relation<?> relation = scatterPlotProjector.getRelation();
                if (!TypeUtil.NUMBER_VECTOR_FIELD.isAssignableFromType(relation.getDataTypeInformation())) {
                    return;
                }
                VisualizationTask visualizationTask = new VisualizationTask(DistanceFunctionVisualization.NAME, visualizerContext, abstractMaterializeKNNPreprocessor, relation, DistanceFunctionVisualization.this);
                visualizationTask.level = 99;
                visualizationTask.addUpdateFlags(11);
                visualizerContext.addVis(abstractMaterializeKNNPreprocessor, visualizationTask);
                visualizerContext.addVis(scatterPlotProjector, visualizationTask);
            }
        });
    }

    public static double getLPNormP(AbstractMaterializeKNNPreprocessor<?> abstractMaterializeKNNPreprocessor) {
        DistanceFunction<?> distanceFunction = abstractMaterializeKNNPreprocessor.getDistanceQuery().getDistanceFunction();
        if (LPNormDistanceFunction.class.isInstance(distanceFunction)) {
            return ((LPNormDistanceFunction)distanceFunction).getP();
        }
        return Double.NaN;
    }

    public static boolean isAngularDistance(AbstractMaterializeKNNPreprocessor<?> abstractMaterializeKNNPreprocessor) {
        DistanceFunction<?> distanceFunction = abstractMaterializeKNNPreprocessor.getDistanceQuery().getDistanceFunction();
        if (CosineDistanceFunction.class.isInstance(distanceFunction)) {
            return true;
        }
        return ArcCosineDistanceFunction.class.isInstance(distanceFunction);
    }

    public static Element drawCosine(SVGPlot sVGPlot, Projection2D projection2D, NumberVector numberVector, double d) {
        double[] dArray = projection2D.fastProjectDataToRenderSpace(new double[projection2D.getInputDimensionality()]);
        double[] dArray2 = projection2D.fastProjectDataToRenderSpace(numberVector);
        Object object = projection2D.fastProjectRenderToDataSpace(dArray2[0] + 10.0, dArray2[1]);
        double[] dArray3 = projection2D.fastProjectRenderToDataSpace(dArray2[0], dArray2[1] + 10.0);
        double[] dArray4 = numberVector.getColumnVector().getArrayRef();
        VMath.minusEquals((double[])object, dArray4);
        VMath.minusEquals(dArray3, dArray4);
        VMath.timesEquals((double[])object, 1.0 / VMath.euclideanLength((double[])object));
        VMath.timesEquals(dArray3, 1.0 / VMath.euclideanLength(dArray3));
        double d2 = VMath.scalarProduct((double[])object, dArray3);
        if (Math.abs(d2) > 1.0E-10) {
            LoggingUtil.warning("Projection does not seem to be orthogonal?");
        }
        d2 = VMath.scalarProduct(dArray4, (double[])object);
        double d3 = VMath.scalarProduct(dArray4, dArray3);
        double d4 = Math.cos(d);
        double d5 = MathUtil.cosToSin(d, d4);
        double d6 = d4 * d2 - d5 * d3;
        double d7 = d5 * d2 + d4 * d3;
        double d8 = d4 * d2 + d5 * d3;
        double d9 = -d5 * d2 + d4 * d3;
        double[] dArray5 = VMath.copy(dArray4);
        double[] dArray6 = VMath.copy(dArray4);
        VMath.plusTimesEquals(dArray5, (double[])object, -d2 + d6);
        VMath.plusTimesEquals(dArray5, dArray3, -d3 + d7);
        VMath.plusTimesEquals(dArray6, (double[])object, -d2 + d8);
        VMath.plusTimesEquals(dArray6, dArray3, -d3 + d9);
        double[] dArray7 = projection2D.fastProjectDataToRenderSpace(dArray5);
        double[] dArray8 = projection2D.fastProjectDataToRenderSpace(dArray6);
        object = projection2D.estimateViewport();
        VMath.minusEquals(dArray7, dArray);
        VMath.minusEquals(dArray8, dArray);
        VMath.timesEquals(dArray7, ((CanvasSize)object).continueToMargin(dArray, dArray7));
        VMath.timesEquals(dArray8, ((CanvasSize)object).continueToMargin(dArray, dArray8));
        VMath.plusEquals(dArray7, dArray);
        VMath.plusEquals(dArray8, dArray);
        dArray3 = VMath.minus(dArray, dArray7);
        dArray4 = VMath.minus(dArray, dArray8);
        VMath.timesEquals(dArray3, ((CanvasSize)object).continueToMargin(dArray7, dArray3));
        VMath.timesEquals(dArray4, ((CanvasSize)object).continueToMargin(dArray8, dArray4));
        VMath.plusEquals(dArray3, dArray7);
        VMath.plusEquals(dArray4, dArray8);
        SVGPath sVGPath = new SVGPath();
        sVGPath.moveTo(dArray3);
        sVGPath.lineTo(dArray7);
        sVGPath.moveTo(dArray4);
        sVGPath.lineTo(dArray8);
        return sVGPath.makeElement(sVGPlot);
    }

    public class Instance
    extends AbstractScatterplotVisualization
    implements DataStoreListener {
        public static final String KNNMARKER = "kNNMarker";
        public static final String KNNDIST = "kNNDist";
        public static final String DISTANCEFUNCTION = "distancefunction";
        private AbstractMaterializeKNNPreprocessor<? extends NumberVector> result;

        public Instance(VisualizationTask visualizationTask, VisualizationPlot visualizationPlot, double d, double d2, Projection projection) {
            super(visualizationTask, visualizationPlot, d, d2, projection);
            this.result = (AbstractMaterializeKNNPreprocessor)visualizationTask.getResult();
            this.addListeners();
        }

        @Override
        public void fullRedraw() {
            this.setupCanvas();
            StyleLibrary styleLibrary = this.context.getStyleLibrary();
            this.addCSSClasses(this.svgp);
            double d = DistanceFunctionVisualization.getLPNormP(this.result);
            boolean bl = DistanceFunctionVisualization.isAngularDistance(this.result);
            double d2 = styleLibrary.getSize("plot.selection");
            DBIDSelection dBIDSelection = this.context.getSelection();
            if (dBIDSelection != null) {
                DBIDs dBIDs = dBIDSelection.getSelectedIds();
                DBIDIter dBIDIter = dBIDs.iter();
                while (dBIDIter.valid()) {
                    Object object;
                    Object object2;
                    KNNList kNNList = this.result.get(dBIDIter);
                    DBIDRef dBIDRef = kNNList.iter();
                    while (dBIDRef.valid()) {
                        try {
                            object2 = this.proj.fastProjectDataToRenderSpace((NumberVector)this.rel.get(dBIDRef));
                            if (object2[0] == object2[0] && object2[1] == object2[1]) {
                                object = this.svgp.svgCircle(object2[0], object2[1], d2);
                                SVGUtil.addCSSClass((Element)object, KNNMARKER);
                                this.layer.appendChild((Node)object);
                                Element element = this.svgp.svgText(object2[0] + d2, object2[1] + d2, Double.toString(dBIDRef.doubleValue()));
                                SVGUtil.addCSSClass(element, KNNDIST);
                                this.layer.appendChild(element);
                            }
                        }
                        catch (ObjectNotFoundException objectNotFoundException) {
                            // empty catch block
                        }
                        dBIDRef.advance();
                    }
                    dBIDRef = kNNList.get(kNNList.size() - 1);
                    if (d == 1.0) {
                        object2 = SVGHyperSphere.drawManhattan(this.svgp, this.proj, (NumberVector)this.rel.get(dBIDIter), dBIDRef.doubleValue());
                    } else if (d == 2.0) {
                        object2 = SVGHyperSphere.drawEuclidean(this.svgp, this.proj, (NumberVector)this.rel.get(dBIDIter), dBIDRef.doubleValue());
                    } else if (!Double.isNaN(d)) {
                        object2 = SVGHyperSphere.drawLp(this.svgp, this.proj, (NumberVector)this.rel.get(dBIDIter), dBIDRef.doubleValue(), d);
                    } else if (bl) {
                        object = (NumberVector)this.rel.get(dBIDIter);
                        double d3 = Math.acos(VectorUtil.cosAngle((NumberVector)object, (NumberVector)this.rel.get(dBIDRef)));
                        object2 = DistanceFunctionVisualization.drawCosine(this.svgp, this.proj, (NumberVector)object, d3);
                    } else {
                        object2 = null;
                    }
                    if (object2 != null) {
                        SVGUtil.addCSSClass((Element)object2, DISTANCEFUNCTION);
                        this.layer.appendChild((Node)object2);
                    }
                    dBIDIter.advance();
                }
            }
        }

        private void addCSSClasses(SVGPlot sVGPlot) {
            CSSClass cSSClass;
            StyleLibrary styleLibrary = this.context.getStyleLibrary();
            if (!sVGPlot.getCSSClassManager().contains(KNNMARKER)) {
                cSSClass = new CSSClass(this, KNNMARKER);
                cSSClass.setStatement("fill", "darkgreen");
                cSSClass.setStatement("opacity", styleLibrary.getOpacity("plot.selection"));
                sVGPlot.addCSSClassOrLogError(cSSClass);
            }
            if (!sVGPlot.getCSSClassManager().contains(DISTANCEFUNCTION)) {
                cSSClass = new CSSClass(this, DISTANCEFUNCTION);
                cSSClass.setStatement("stroke", "red");
                cSSClass.setStatement("stroke-width", styleLibrary.getLineWidth("plot"));
                cSSClass.setStatement("fill", "none");
                cSSClass.setStatement("stroke-linecap", "round");
                cSSClass.setStatement("stroke-linejoin", "round");
                sVGPlot.addCSSClassOrLogError(cSSClass);
            }
            if (!sVGPlot.getCSSClassManager().contains(KNNDIST)) {
                cSSClass = new CSSClass(this, KNNDIST);
                cSSClass.setStatement("fill", "black");
                cSSClass.setStatement("font-size", styleLibrary.getTextSize("plot"));
                cSSClass.setStatement("font-family", styleLibrary.getFontFamily("plot"));
                sVGPlot.addCSSClassOrLogError(cSSClass);
            }
        }
    }
}

